% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neg.cfi.R
\name{neg.cfi}
\alias{neg.cfi}
\alias{print.neg.cfi}
\title{Equivalence Tests for CFI}
\usage{
neg.cfi(
  mod,
  alpha = 0.05,
  eq.bound,
  modif.eq.bound = FALSE,
  ci.method = "equiv",
  nbootpd = 50,
  nboot = 250L,
  round = 3,
  plot = TRUE,
  saveplot = TRUE
)

\method{print}{neg.cfi}(x, ...)
}
\arguments{
\item{mod}{lavaan model object}

\item{alpha}{desired alpha level (default = .05)}

\item{eq.bound}{lower end of equivalence interval for comparison; must be .99, .95, .92 or .90 if modif.eq.bound = TRUE}

\item{modif.eq.bound}{should the lower end of the equivalence interval be modified (default = FALSE)}

\item{ci.method}{method used to calculate confidence interval; options are "yuan", "equiv" or "yhy.boot"; "yuan" corresponds to (1-alpha) percent CI, "equiv" corresponds to (1-2alpha) percent CI, "yhy.boot" corresponds to (1-2alpha) percent boot CI (default = "equiv")}

\item{nbootpd}{number of bootstrap samples by "yhy.boot" for pd function}

\item{nboot}{number of bootstrap samples if "yhy.boot" is selected as ci.method (default = 250L)}

\item{round}{number of digits to round equivalence bound and confidence interval bounds (default = 3)}

\item{plot}{logical, plotting the results (default = TRUE)}

\item{saveplot}{saving plots (default = FALSE)}

\item{x}{object of class \code{neg.cfi}}

\item{...}{extra arguments}
}
\value{
returns a \code{list} containing analysis and respective statistics
  and decision.
\itemize{
   \item \code{title1} The title of the CFI equivalence test. The appropriate title of the test will be displayed depending on the ci.method chosen and whether modif.eq.bound is TRUE or FALSE.
   \item \code{cfi_index} The CFI index.
   \item \code{ci.method} The method for confidence interval calculation.
   \item \code{cfi_eq} The lower end of the confidence interval for the CFI index.
   \item \code{eq.bound} The equivalence bound.
   \item \code{PD} Proportional distance (PD).
   \item \code{cilpd} Lower bound of the 1-alpha CI for the PD.
   \item \code{ciupd} Upper bound of the 1-alpha CI for the PD.
}
}
\description{
Function performs one of six equivalence tests for CFI fit index.
}
\details{
#'
The user specifies the lavaan fitted model object, the desired equivalence bound, and method of confidence interval computation. By default, the function does not modify the equivalence bounds according to Yuan et al. (2016). The user can also choose to instead run an equivalence test using a modified equivalence bound if the equivalence bound to be modified is .01, .05, .08, or .10. Alpha level can also be modified.

For information on modified equivalence bounds see Yuan, K. H., Chan, W., Marcoulides, G. A., & Bentler, P. M. (2016). Assessing structural equation models by equivalence testing with adjusted fit indexes. Structural Equation Modeling: A Multidisciplinary Journal, 23(3), 319-330. doi: https://doi.org/10.1080/10705511.2015.1065414.

The proportional distance quantifies the proportional distance from 0 to the nearest negligible effect (equivalence) interval (here, eiU). As values get farther from 0 the relationship becomes more substantial, with values greater than 1 indicating that the effect falls outside of the negligible effect (equivalence) interval.
}
\examples{
d <- lavaan::HolzingerSwineford1939
hs.mod <- 'visual =~ x1 + x2 + x3
textual =~ x4 + x5 + x6
speed =~ x7 + x8 + x9'
fit1 <- lavaan::cfa(hs.mod, data = d)
neg.cfi(mod = fit1, alpha = .05, eq.bound = .95,  modif.eq.bound = FALSE, ci.method = "equiv",
round = 3, plot = TRUE)

}
\author{
Rob Cribbie \email{cribbie@yorku.ca} and
  Nataly Beribisky \email{natalyb1@yorku.ca}
}
