% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/get_datasets.R
\name{get_datasets}
\alias{get_datasets}
\title{Obtain dataset information from the Neotoma Paleoecological Database.}
\usage{
get_datasets(siteid, datasettype, piid, altmin, altmax, loc, gpid, taxonids,
  taxonname, ageold, ageyoung, ageof, subdate)
}
\arguments{
\item{siteid}{A numeric value corresponding to the site ID.}

\item{datasettype}{A character string corresponding to one of the allowed dataset types in the Neotoma Database.  Allowed types include: \code{"geochronologic"}, \code{"loss-on-ignition"}, \code{"pollen"}, \code{"plant macrofossils"}, \code{"vertebrate fauna"}, \code{"mollusks"}, and \code{"pollen surface sample"}.}

\item{piid}{Numeric value for the Principle Investigator's ID number.}

\item{altmin}{Numeric value indicating the minimum altitude for the site (can be used alone or with \code{altmax}).}

\item{altmax}{Numeric value indicating the maximum altitude for the site (can be used alone or with \code{altmin}).}

\item{loc}{A numeric vector \code{c(lonW, latS, lonE, latN)} representing the bounding box within which to search for sites.  The convention here is to use negative values for longitudes west of Grewnwich or longitudes south of the equator}

\item{gpid}{A character string or numeric value, must correspond to a valid geopolitical identity in the Neotoma Database.  Use get.tables('GeoPoliticalUnits') for a list of acceptable values, or link here: \url{http://api.neotomadb.org/apdx/geopol.htm}}

\item{taxonids}{A numeric identifier for the taxon.  See \code{\link{get_table}} and use \code{get_tables('Taxa')} for a list of acceptable values.}

\item{taxonname}{A character string corresponding to a valid taxon identity in the Neotoma Database.  See \code{\link{get_table}} and use \code{get_table('Taxa')} for a list of acceptable values.}

\item{ageold}{The oldest date acceptable for the search (in years before present).}

\item{ageyoung}{The youngest date acceptable for the search.}

\item{ageof}{If a taxon ID or taxon name is defined this parameter must be set to \code{"taxon"}, otherwise it may refer to \code{"sample"}, in which case the age bounds are for any samples within datasets or \code{"dataset"} if you want only datasets that are within the bounds of ageold and ageyoung.}

\item{subdate}{Date of dataset submission, either YYYY-MM-DD or MM-DD-YYYY.}
}
\description{
Deprecated - see \code{get_dataset}.
}
\author{
Simon J. Goring \email{simon.j.goring@gmail.com}
}
\references{
Neotoma Project Website: http://www.neotomadb.org
API Reference:  http://api.neotomadb.org/doc/resources/contacts
}
\keyword{IO}
\keyword{connection}

