% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_site.R
\name{get_site}
\alias{get_site}
\title{Return Site Information.}
\usage{
get_site(sitename, altmin, altmax, loc, gpid, ...)
}
\arguments{
\item{sitename}{character string representing the full or partial site name, or an object of class \code{dataset}, \code{dataset_list}, \code{download} or \code{download_list}}

\item{altmin}{Minimum site altitude  (in m).}

\item{altmax}{Maximum site altitude (in m).}

\item{loc}{A numeric vector c(lonW, latS, lonE, latN) representing the bounding box within which to search for sites.  The convention here is to use negative values for longitudes west of Grewnwich or longitudes south of the equator.}

\item{gpid}{A character string or numeric value, must correspond to a valid geopolitical identity in the Neotoma Database.  Use get.tables('GeoPoliticalUnits') for a list of acceptable values, or link here: http://api.neotomadb.org/apdx/geopol.htm}

\item{...}{Optional additional arguments}
}
\value{
A data frame:

 \item{\code{siteid}}{Unique database record identifier for the site.}
 \item{\code{sitename}}{Name of the site.}
 \item{\code{long}}{Mean longitude, in decimal degrees, for a site (-180 to 180).}
 \item{\code{lat}}{Mean latitude, in decimal degrees, for a site (-90 to 90).}
 \item{\code{elev}}{Elevation in meters.}
 \item{\code{description}}{Free form description of a site, including such information as physiography and vegetation around the site.}
 \item{\code{long_acc}}{If the site is described by a bounding box this is the box width.}
 \item{\code{lat_acc}}{If the site is described by a bounding box this is the box height.}
}
\description{
Return site information from the Neotoma Paleoecological Database.

\code{get_site} returns site information from the Neotoma Paleoecological Database
   based on parameters defined by the user.
}
\examples{
\dontrun{
#  What is the distribution of site elevations in Neotoma?
all.sites <- get_site()  #takes a bit of time.

plot(density(all.sites$elev, from = 0, na.rm=TRUE),
main = 'Altitudinal Distribution of Neotoma Sites', xlab = 'Altitude (m)', log='x')

#  Get site information from a dataset:
nw.datasets <- get_dataset(loc = c(-140, 50, -110, 65), 
                           datasettype='pollen',
                           taxonname='Pinus*')
                           
nw.sites <- get_site(nw.datasets)

}
}
\references{
Neotoma Project Website: http://www.neotomadb.org
API Reference:  http://api.neotomadb.org/doc/resources/sites
}
\author{
Simon J. Goring \email{simon.j.goring@gmail.com}
}
\keyword{IO}
\keyword{connection}
