% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/link_network_map.R
\name{link_network_map2}
\alias{link_network_map2}
\title{Link a network and a map with a lookup table}
\usage{
link_network_map2(m, n, lkp, m_name = NULL, n_name = NULL)
}
\arguments{
\item{m}{Object of class \code{sf}.}

\item{n}{Object of class \code{network} or \code{igraph}.}

\item{lkp}{Lookup table, a \code{data.frame}.}

\item{m_name}{Optional character, name of field in \code{m} and of column in
\code{lkp} (first column of \code{lkp} is used if \code{NULL}).}

\item{n_name}{Optional character, name of vertex attribute in \code{n} and of
column in \code{lkp}  (second column of \code{lkp} is used if \code{NULL}).}
}
\value{
On success a list with two vectors, one of features in \code{m} present
both in the lookup table and in \code{n}, the other of nodes in \code{n} present
both in the lookup table and in \code{m}, \code{-1} on error.
}
\description{
Checks which vertices of a network object can be represented with features of
a sf object with a lookup table.
}
