% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forest.netcomb.R
\name{forest.netcomb}
\alias{forest.netcomb}
\title{Forest plot for additive network meta-analysis}
\usage{
\method{forest}{netcomb}(x, pooled = ifelse(x$comb.random, "random",
  "fixed"), reference.group = x$reference.group,
  baseline.reference = x$baseline.reference, leftcols = "studlab",
  leftlabs = "Treatment", rightcols = c("effect", "ci"),
  rightlabs = NULL, digits = gs("digits.forest"),
  small.values = "good", smlab = NULL, sortvar = x$seq,
  backtransf = x$backtransf, lab.NA = ".", add.data,
  drop.reference.group = FALSE, ...)
}
\arguments{
\item{x}{An object of class \code{netcomb}.}

\item{pooled}{A character string indicating whether results for the
fixed effect (\code{"fixed"}) or random effects model
(\code{"random"}) should be plotted. Can be abbreviated.}

\item{reference.group}{Reference treatment(s).}

\item{baseline.reference}{A logical indicating whether results
should be expressed as comparisons of other treatments versus the
reference treatment (default) or vice versa.}

\item{leftcols}{A character vector specifying (additional) columns
to be plotted on the left side of the forest plot or a logical
value (see \code{\link{forest.meta}} help page for details).}

\item{leftlabs}{A character vector specifying labels for
(additional) columns on left side of the forest plot (see
\code{\link{forest.meta}} help page for details).}

\item{rightcols}{A character vector specifying (additional) columns
to be plotted on the right side of the forest plot or a logical
value (see \code{\link{forest.meta}} help page for details).}

\item{rightlabs}{A character vector specifying labels for
(additional) columns on right side of the forest plot (see
\code{\link{forest.meta}} help page for details).}

\item{digits}{Minimal number of significant digits for treatment
effects and confidence intervals, see \code{print.default}.}

\item{small.values}{A character string specifying whether small
treatment effects indicate a beneficial (\code{"good"}) or
harmful (\code{"bad"}) effect, can be abbreviated; see
\code{\link{netrank}}.}

\item{smlab}{A label printed at top of figure. By default, text
indicating either fixed effect or random effects model is
printed.}

\item{sortvar}{An optional vector used to sort the individual
studies (must be of same length as the total number of
treatments).}

\item{backtransf}{A logical indicating whether results should be
back transformed in forest plots. If \code{backtransf = TRUE},
results for \code{sm = "OR"} are presented as odds ratios rather
than log odds ratios, for example.}

\item{lab.NA}{A character string to label missing values.}

\item{add.data}{An optional data frame with additional columns to
print in forest plot (see Details).}

\item{drop.reference.group}{A logical indicating whether the
reference group should be printed in the forest plot.}

\item{\dots}{Additional arguments for \code{\link{forest.meta}}
function.}
}
\description{
Draws a forest plot in the active graphics window (using grid
graphics system).
}
\details{
A forest plot, also called confidence interval plot, is drawn in
the active graphics window.

Argument \code{sortvar} can be either a numeric or character vector
with length of number of treatments. If \code{sortvar} is numeric
the \code{\link[base]{order}} function is utilised internally to
determine the order of values. If \code{sortvar} is character it
must be a permutation of the treatment names. It is also possible
to to sort by treatment comparisons (\code{sortvar = TE}, etc.),
standard error (\code{sortvar = seTE}), and number of studies with
direct treatment comparisons (\code{sortvar = k}).

Argument \code{add.data} can be used to add additional columns to
the forest plot. This argument must be a data frame with the same
row names as the treatment effects matrices in R object \code{x},
i.e., \code{x$TE.fixed} or \code{x$TE.random}.

For more information see help page of \code{\link{forest.meta}}
function.
}
\examples{
data(Linde2016)

# Only consider studies including Face-to-face PST (to reduce
# runtime of example)
#
face <- subset(Linde2016, id \%in\% c(16, 24, 49, 118))

# Conduct random effects network meta-analysis
#
net1 <- netmeta(lnOR, selnOR, treat1, treat2, id,
                data = face, ref = "placebo",
                sm = "OR", comb.fixed = FALSE)

# Additive model for treatment components (with placebo as inactive
# treatment)
#
nc1 <- netcomb(net1, inactive = "placebo")
#
forest(nc1)

\dontrun{
# Specify, order of treatments
#
trts <- c("TCA", "SSRI", "SNRI", "NRI", "Low-dose SARI", "NaSSa",
          "rMAO-A", "Ind drug", "Hypericum", "Face-to-face CBT",
          "Face-to-face PST", "Face-to-face interpsy", "Face-to-face psychodyn",
          "Other face-to-face", "Remote CBT", "Self-help CBT", "No contact CBT",
          "Face-to-face CBT + SSRI", "Face-to-face interpsy + SSRI",
          "Face-to-face PST + SSRI", "UC", "Placebo")
#
# Note, three treatments are actually combinations of 'SSRI' with
# other components:
# "Face-to-face CBT + SSRI",
# "Face-to-face interpsy + SSRI",
# "Face-to-face PST + SSRI"

# Conduct random effects network meta-analysis
#
net2 <- netmeta(lnOR, selnOR, treat1, treat2, id,
                data = Linde2016, ref = "placebo",
                seq = trts,
                sm = "OR", comb.fixed = FALSE)
#
summary(net2)

# Additive model for treatment components (with placebo as inactive
# treatment)
#
nc2 <- netcomb(net2, inactive = "placebo")
#
forest(nc2)
}

}
\seealso{
\code{\link{netcomb}}, \code{\link{discomb}},
  \code{\link{forest.meta}}
}
\author{
Guido Schwarzer \email{sc@imbi.uni-freiburg.de}
}
\keyword{hplot}
