% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.data.frame.netconnection.R
\name{as.data.frame.netconnection}
\alias{as.data.frame.netconnection}
\title{Create a data frame from an object of class netconnection}
\usage{
\method{as.data.frame}{netconnection}(x, ...)
}
\arguments{
\item{x}{An object of class \code{netconnection}.}

\item{\dots}{Additional arguments (ignored).}
}
\value{
A data frame is returned by the function
  \code{as.data.frame}.
}
\description{
The \code{as.data.frame} method returns a data frame containing
information on membership of studies / pairwise comparisons to a
(sub)network.
}
\examples{
# Artificial example with two subnetworks
#
t1 <- c("G", "B", "B", "D", "A", "F")
t2 <- c("B", "C", "E", "E", "H", "A")
#
nc2 <- netconnection(t1, t2)
print(nc2, details = TRUE)

as.data.frame(nc2)

}
\seealso{
\code{\link{netconnection}}
}
\author{
Guido Schwarzer \email{sc@imbi.uni-freiburg.de}
}
