% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R
\name{policy}
\alias{policy}
\title{Missing Values Policy}
\description{
Missing Values Policy
}
\details{
Compositional data are quantitative (positive) descriptions of the parts
of some whole, carrying relative, rather than absolute, information
(ie. only relative changes are relevant; Aitchison 1986).

Basically, two situations can be outlined:
\itemize{
\item The presence of zeros: these are considered as observed quantities,
but which happen to be below the detection limit (thus interpreted as
small unknown values).
\item The presence of missing values (\code{NA}): these indicate that the quantities
in question have not been observed.
}

When creating a \code{\linkS4class{CompositionMatrix}} object, the presence of zero
and \code{\link{NA}} values is allowed: this makes it possible to explore and
visualize the data while preserving the missing structure. However, the
user must deal with these missing values before proceeding further (e.g.
by removing incomplete cases or replacing the values concerned): log-ratio
transformations cannot be computed in the presence of missing values.
}
\note{
If you need more advanced features (e.g. imputation of missing values),
you should consider the \link[compositions:compmiss]{compositions}
or \link[robCompositions:impCoda]{robCompositions} package.
}
\references{
Aitchison, J. (1986). \emph{The Statistical Analysis of Compositional Data}.
London: Chapman and Hall.
}
\seealso{
Other imputation methods: 
\code{\link{missing}},
\code{\link{zero}}
}
\concept{imputation methods}
