% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/variance.R
\docType{methods}
\name{variance}
\alias{variance}
\alias{variance-method}
\alias{variance,LogRatio-method}
\title{Log-Ratios Variances}
\usage{
variance(x, ...)

\S4method{variance}{LogRatio}(x, row_weights = NULL, column_weights = TRUE)
}
\arguments{
\item{x}{A \code{\linkS4class{CompositionMatrix}} object.}

\item{...}{Currently not used.}

\item{row_weights}{A \code{\link{numeric}} vector of row weights. If \code{NULL} (the
default), equal weights are used.}

\item{column_weights}{A \code{\link{logical}} scalar: should the weights of the
log-ratio be used? If \code{FALSE}, equally-weighted parts are used.
Alternatively, a positive \code{\link{numeric}} vector of weights can be specified.}
}
\value{
A \code{\link{numeric}} vector of individual variances.
}
\description{
Computes log-ratio (weighted) variances.
}
\examples{
## Data from Aitchison 1986
data("hongite")

## Coerce to compositional data
coda <- as_composition(hongite)

## Total variance (1)
variance_total(coda)

## Metric standard deviation
variance_total(coda, sd = TRUE)

## CLR transformation
clr <- transform_clr(coda)

## Individual log-ratio variances
variance(clr)

## Total log-ratio variance (2)
variance_total(clr)

## Proportionality between (1) and (2)
## See Aitchison 1997
variance_total(coda) * (1 / ncol(coda)) * (1 - (1 / nrow(coda)))
}
\references{
Greenacre, M. J. (2019). \emph{Compositional Data Analysis in Practice}.
Boca Raton: CRC Press.
}
\seealso{
Other statistics: 
\code{\link{aggregate}()},
\code{\link{condense}()},
\code{\link{covariance}()},
\code{\link{dist}},
\code{\link{mahalanobis}()},
\code{\link{margin}()},
\code{\link{mean}()},
\code{\link{pip}()},
\code{\link{quantile}()},
\code{\link{scale}()},
\code{\link{variance_total}()},
\code{\link{variation}()}
}
\author{
N. Frerebeau
}
\concept{statistics}
