% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load.R
\name{load}
\alias{load}
\title{Load an nfer specification from a file.}
\usage{
load(specfile, loglevel = 0)
}
\arguments{
\item{specfile}{The name of file containing the nfer specification to load.}

\item{loglevel}{(Optional) The logging level to set (0-4), where 0 is only
warnings and errors and 3 is debug.  Default is 0.}
}
\value{
A handle to the nfer specification, loaded into R.
}
\description{
This function loads an existing nfer specification, stored in a file,
into R in a format that can be used by the \code{nfer::apply} function.
See \url{http://nfer.io/} for information on how to write nfer specifications.
}
\details{
Nfer specifications consist of rules that describe a relationship between
pairs of intervals.  These relationships describe new intervals that can
then be used to describe more intervals.  The result is a hierarchy of
intervals.  Although the algorithm takes intervals as its input, event
traces are actually the target, so events are converted to intervals with
zero duration.
}
\examples{
test <- nfer::load(system.file("extdata", "ops.nfer", package = "nfer"))
ssps <- nfer::load(system.file("extdata", "ssps.nfer", package = "nfer"), loglevel=1)
}
