% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_participation.R
\name{load_participation}
\alias{load_participation}
\title{Load Participation Data}
\usage{
load_participation(
  seasons = most_recent_season(),
  include_pbp = FALSE,
  file_type = getOption("nflreadr.prefer", default = "rds")
)
}
\arguments{
\item{seasons}{A numeric vector of 4-digit years associated with given NFL seasons - defaults to latest season. If set to \code{TRUE}, returns all available data since 2016.}

\item{include_pbp}{a logical: download and join pbp to this data?}

\item{file_type}{One of \code{c("rds", "qs", "csv", "parquet")}. Can also be set globally with
\code{options(nflreadr.prefer)}}
}
\value{
A dataframe of participation data, optionally merged with play by play
}
\description{
Loads participation data from the \href{https://github.com/nflverse/nflverse-data}{nflverse-data repository}
}
\examples{
\donttest{
try({ # prevents cran errors
  load_participation(seasons = 2020, include_pbp = TRUE)
})
}

}
