% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_depth_charts.R
\name{load_depth_charts}
\alias{load_depth_charts}
\title{Load Weekly Depth Charts}
\usage{
load_depth_charts(
  seasons = most_recent_season(),
  file_type = getOption("nflreadr.prefer", default = "rds")
)
}
\arguments{
\item{seasons}{a numeric vector specifying what seasons to return, if \code{TRUE} returns all available data. Defaults to latest season.}

\item{file_type}{One of \code{c("rds", "qs", "csv", "parquet")}. Can also be set globally with
\code{options(nflreadr.prefer)}}
}
\value{
A tibble of week-level depth charts for each team.
}
\description{
Loads depth charts for each NFL team for each week back to 2001.
}
\examples{
\donttest{
try({ # prevents cran errors
  load_depth_charts(2020)
})
}

}
\seealso{
\url{https://nflreadr.nflverse.com/articles/dictionary_depth_charts.html} for a web version of the dictionary

\code{\link{dictionary_depth_charts}} for the data dictionary as bundled within the package

Issues with this data should be filed here: \url{https://github.com/nflverse/nflverse-data}
}
