% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_nhdplus.R
\name{map_nhdplus}
\alias{map_nhdplus}
\title{Make Interactive Map of NHDPlus}
\usage{
map_nhdplus(
  outlets = NULL,
  bbox = NULL,
  streamorder = NULL,
  nhdplus_data = NULL,
  gpkg = NULL,
  flowline_only = NULL,
  plot_config = NULL,
  overwrite = TRUE,
  cache_data = NULL,
  return_map = FALSE
)
}
\arguments{
\item{outlets}{list of nldi outlets. Other inputs are coerced into nldi outlets, see details.}

\item{bbox}{object of class bbox with a defined crs. See examples.}

\item{streamorder}{integer only streams of order greater than or equal will be returned}

\item{nhdplus_data}{geopackage containing source nhdplus data (omit to download)}

\item{gpkg}{path and file with .gpkg ending. If omitted, no file is written.}

\item{flowline_only}{boolean only subset and plot flowlines only, default=FALSE}

\item{plot_config}{list containing plot configuration, see details.}

\item{overwrite}{passed on the \link{subset_nhdplus}.}

\item{cache_data}{character path to rds file where all plot data can be cached.
If file doesn't exist, it will be created. If set to FALSE, all caching will
be turned off -- this includes basemap tiles.}

\item{return_map}{if FALSE (default), a data.frame of plot data is returned invisibly in NAD83 Lat/Lon, if TRUE the leaflet object is returned}
}
\value{
data.frame or leaflet map (see return_map)
}
\description{
Given a list of outlets, get their basin boundaries and network and return a leaflet map in
EPSG:4326.
}
\details{
map_nhdplus supports several input specifications. An unexported function "as_outlet"
is used to convert the outlet formats as described below.
\enumerate{
  \item if outlets is omitted, the bbox input is required and all nhdplus data
  in the bounding box is plotted.
  \item If outlets is a list of integers, it is assumed to be NHDPlus IDs (comids)
  and all upstream tributaries are plotted.
  \item if outlets is an integer vector, it is assumed to be all NHDPlus IDs (comids)
  that should be plotted. Allows custom filtering.
  \item If outlets is a character vector, it is assumed to be NWIS site ids.
  \item if outlets is a list containing only characters, it is assumed to be a list
  of nldi features and all upstream tributaries are plotted.
  \item if outlets is a data.frame with point geometry, a point in polygon match
  is performed and upstream with tributaries from the identified catchments is plotted.
}

See \link{plot_nhdplus} for details on plot configuration.
}
\examples{
\donttest{
map_nhdplus("05428500")

map_nhdplus("05428500", streamorder = 2)

map_nhdplus(list(13293970, 13293750))

source(system.file("extdata/sample_data.R", package = "nhdplusTools"))

map_nhdplus(list(13293970, 13293750), streamorder = 3, nhdplus_data = sample_data)

#return leaflet object
map_nhdplus("05428500", return_map = TRUE)
}
}
