% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nhl_utils.R
\name{util_rbindlist}
\alias{util_rbindlist}
\title{Safely \code{rbind} multiple data.frames}
\usage{
util_rbindlist(lst, fill = TRUE)
}
\arguments{
\item{lst}{\code{list()}, of data frames to be \code{rbind}-ed into one.}

\item{fill}{\code{logical(1)}, if \code{FALSE}, this function just
returns \code{do.call(rbind, lst)}.}
}
\value{
\code{data.frame}, the elements of \code{lst}, \code{rbind}-ed into one.
}
\description{
Attempts to replace \code{do.call(rbind, lst)}
taking into consideration that some data frames in
\code{lst} can have missing columns. Those are filled by
\code{NA} values.
}
\examples{
  nhlapi:::util_rbindlist(list(
    datasets::mtcars[1, 2:3],
    datasets::mtcars[2, 4:5]
  ))
}
