% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nhl_teams.R
\name{nhl_url_teams}
\alias{nhl_url_teams}
\title{Create an NHL API URL for teams}
\usage{
nhl_url_teams(teamIds = NULL, params = NULL)
}
\arguments{
\item{teamIds}{\code{integer()}, ids of the teams or \code{NULL} (default)
for all teams. As of end of 2019, the valid team ids seem to be
in the \code{1:54} range.}

\item{params}{\verb{named list()} of parameters that will be
concatenated to the end of the URLs after \verb{?}. Parameters
can have multiple values, in which case multiple URLs
are created. Multiple parameters are separated by \code{&}.}
}
\value{
\code{character()}, API URLs, same length as \code{teamIds} or
length \code{1} if \code{teamIds} is \code{NULL}.
}
\description{
Create an NHL API URL for teams
}
\examples{
  nhlapi:::nhl_url_teams()
  nhlapi:::nhl_url_teams(1:3)

}
