% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in Rtmp3xd4YE/filefb21abffc7c
\name{buildMCMC}
\alias{buildMCMC}
\title{Create an MCMC function, from an MCMCspec object}
\usage{
buildMCMC(mcmcspec, ...)
}
\arguments{
\item{mcmcspec}{An object of class MCMCspec that specifies the model, samplers, monitors, and thinning intervals for the resulting MCMC function.  See \code{configureMCMC} for details of creating MCMCspec objects.  Alternatively, \code{mcmcspec} may a NIMBLE model object, in which case an MCMC function corresponding to the defult MCMC specification for this model is returned.}\item{...}{Additional arguments to be passed to \code{configureMCMC} if \code{mcmcspec} is a NIMBLE model object}}\description{
Accepts a single required argument, which may be of class MCMCspec, or inherit from class modelBaseClass (a NIMBLE model obejct).  Returns an MCMC function; see details section.
}
\details{
Calling buildMCMC(mcmcspec) will produce an R mcmc function object, say 'Rmcmc'.

The Rmcmc function will have arguments:

\code{niter}: The number of iterations to run the MCMC.

\code{reset}: Boolean specifying whether to reset the model and stored samples.  This will simulate into any stochastic nodes with value NA,
propagate values through any deterministic nodes, and calculate all model probabilities.
This will also reset the internal stored MCMC samples.
Specifying \code{reset=FALSE} allows the MCMC algorithm to continue running from where it left off.
Generally, \code{reset=FALSE} should only be used when the MCMC has already been run.  See examples.

\code{simulateAll}: Boolean specifying whether to simulate into all stochastic nodes.  This will overwrite the current values in all stochastic nodes.

Samples corresponding to the \code{monitors} and \code{monitors2} from the MCMCspec are stored into the interval variables \code{mvSamples} and \code{mvSamples2}, respectively.
These may be accessed via:
\code{Rmcmc$mvSamples}
\code{Rmcmc$mvSamples2}

The Rmcmc function may be compiled to a C MCMC object, taking care to compile in the same project as the R model object, using:
\code{Cmcmc <- compileNimble(Rmcmc, project=Rmodel)}

The Cmcmc function will function identically to the Rmcmc object, except acting on the C model object.
}
\examples{
code <- nimbleCode({
 mu ~ dnorm(0, 1)
 x ~ dnorm(mu, 1)
})
Rmodel <- nimbleModel(code)
spec <- configureMCMC(Rmodel)
Rmcmc <- buildMCMC(spec)
Rmcmc$run(10)
samples <- Rmcmc$mvSamples
samples[['x']]
Rmcmc$run(100, reset = FALSE)
}
\author{
Daniel Turek
}

