% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in Rtmpi7IeZS/filee6c579869ca
\docType{class}
\name{MCMCsuiteClass-class}
\alias{MCMCsuiteClass}
\alias{MCMCsuiteClass-class}
\title{Class \code{MCMCsuiteClass}}
\description{
Objects of this class create, run, and organize output from a suite of MCMC algorithms, all applied to the same model, data, and initial values.
This can include WinBUGS, OpenBUGS, JAGS and Stan MCMCs, as well as NIMBLE MCMC algorithms.
Trace plots and density plots for the MCMC samples may also be generated and saved.
}
\examples{
\dontrun{
code <- nimbleCode({
    mu ~ dnorm(0, 1)
    x ~ dnorm(mu, 1)
})
output <- MCMCsuite(code,
                    data = list(x=3),
                    inits = list(mu=0),
                    niter = 10000,
                    monitors = 'mu',
                    MCMCs = c('nimble', 'nimble_RW'),
                    summaryStats = c('mean', 'sd', 'max', 'function(x) max(abs(x))'),
                    makePlot = FALSE)
}
}
\author{
Daniel Turek
}
\seealso{
\link{MCMCsuite}
}

