% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MIX.output_helper.R
\name{getMIX.output}
\alias{getMIX.output}
\title{Extract Point Estimates And Standard Errors of Longitudinal Mixture Models}
\usage{
getMIX.output(
  model,
  nClass,
  sub_Model,
  cluster_TIC,
  y_var,
  curveFun,
  x_type,
  records,
  growth_TIC,
  y_model,
  decompose,
  names
)
}
\arguments{
\item{model}{An object representing a fitted mixture model.}

\item{nClass}{An integer specifying the number of latent classes for the mixture model. It takes the value passed from \code{getMIX()}.}

\item{sub_Model}{A string that specifies the sub-model for latent classes. Supported sub-models include \code{"LGCM"} (for latent
growth curve models), \code{"LCSM"} (for latent change score models), \code{"TVC"} (for latent growth curve models or latent change
score models with a time-varying covariate), \code{"MGM"} (for multivariate latent growth curve models or latent change score models),
and \code{"MED"} (for longitudinal mediation models). It takes the value passed from \code{getMIX()}.}

\item{cluster_TIC}{A string or character vector representing the column name(s) for time-invariant covariate(s) indicating cluster
formations. It takes the value passed from \code{getMIX()}.}

\item{y_var}{A string defining the prefix of the column names corresponding to the outcome variable for each study wave. This is applicable
when \code{sub_Model} is not \code{"MGM"}. For \code{sub_Model} being \code{"MGM"}, \code{y_var} should be a string vector where each element
corresponds to the prefix of the column names for each outcome variable across the study waves. It takes the value passed from \code{getMIX()}.}

\item{curveFun}{A string specifying the functional form of the growth curve. Supported options for \code{y_model = "LGCM"} include:
\code{"linear"} (or \code{"LIN"}), \code{"quadratic"} (or \code{"QUAD"}), \code{"negative exponential"}
(or \code{"EXP"}), \code{"Jenss-Bayley"} (or \code{"JB"}), and \code{"bilinear spline"} (or \code{"BLS"}). Supported options for
\code{y_model = "LCSM"} include: \code{"quadratic"} (or \code{"QUAD"}), \code{"negative exponential"} (or \code{"EXP"}),
\code{"Jenss-Bayley"} (or \code{"JB"}), and \code{"nonparametric"} (or \code{"NonP"}). It takes the value passed from \code{getMIX()}.}

\item{x_type}{A string indicating the type of predictor variable used in the model. Supported values are \code{"baseline"}
and \code{"longitudinal"}. It takes the value passed from \code{getMIX()}.}

\item{records}{A numeric vector denoting the indices of the observed study waves. This applies when \code{sub_Model} is \code{"LGCM"},
\code{"LCSM"} or \code{"TVC"}. For \code{sub_Model} being \code{"MGM"} or \code{"MED"}, \code{records} should be a list of numeric vectors,
where each vector provides the indices of the observed study waves for each longitudinal process. It takes the value passed from \code{getMIX()}.}

\item{growth_TIC}{A string or character vector of column names of time-invariant covariate(s) accounting for the variability
of growth factors if any. It takes the value passed from \code{getMIX()}.}

\item{y_model}{A string that specifies how to fit longitudinal outcomes. Supported values are \code{"LGCM"} and \code{"LCSM"}.
It takes the value passed from \code{getMIX()}.}

\item{decompose}{An integer specifying the decomposition option for temporal states. Supported values include \code{0} (no
decomposition), \code{1} (decomposition with interval-specific slopes as temporal states), \code{2} (decomposition with interval-
specific changes as temporal states), and \code{3} (decomposition with change-from-baseline as temporal states). It takes the value passed
from \code{getMIX()}.}

\item{names}{A character vector specifying parameter names. It takes the value passed from \code{getMIX()}.}
}
\value{
A dataframe containing point estimates and standard errors for the parameters of interest for a mixture model.
}
\description{
This function computes and returns a data frame containing point estimates and standard errors for the parameters of
a mixture model.
}
