% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSbeta5.R
\name{SSbeta5}
\alias{SSbeta5}
\alias{beta5}
\title{self start for Beta 5-parameter function}
\usage{
beta5(temp, mu, tb, a, tc, b)

SSbeta5(temp, mu, tb, a, tc, b)
}
\arguments{
\item{temp}{input vector which is normally \sQuote{temperature}}

\item{mu}{mu parameter (see equation)}

\item{tb}{base (low) temperature at which no expansion accurs}

\item{a}{parameter describing the initial increasing phase}

\item{tc}{critical (high) temperature at which no expasion occurs}

\item{b}{parameter describing the decreasing phase}
}
\value{
beta5: vector of the same length as x (temp) using the beta5 function
}
\description{
Self starter for Beta 5-parameter function
}
\details{
For details see the publication by Yin et al. (1995) \dQuote{A nonlinear model for crop development as a function of temperature }.
Agricultural and Forest Meteorology 77 (1995) 1-16

The form of the equation is: \deqn{exp(mu) * (temp - tb)^a * (tc - temp)^b}.
}
\examples{
\donttest{
require(minpack.lm)
require(ggplot2)
## Temperature response example
data(maizeleafext)
## Fit model
fit <- nlsLM(rate ~ SSbeta5(temp, mu, tb, a, tc, b), data = maizeleafext)
## Visualize
ndat <- data.frame(temp = 0:45)
ndat$rate <- predict(fit, newdata = ndat)
ggplot() + 
   geom_point(data = maizeleafext, aes(temp, rate)) + 
   geom_line(data = ndat, aes(x = temp, y = rate))
}
}
