# nlraa: R package for Nonlinear Regression for Agricultural
# Applications

[![CRAN](http://www.r-pkg.org/badges/version/nlraa)](https://CRAN.R-project.org/package=nlraa)
[![CRAN
downloads total](https://cranlogs.r-pkg.org/badges/grand-total/nlraa)](https://github.com/r-hub/cranlogs.app)
[![CRAN downloads](https://cranlogs.r-pkg.org/badges/nlraa)](https://cran.r-project.org/package=nlraa)

[Documentation](https://femiguez.github.io/nlraa-docs/index.html)

NOTE: the vignettes (nlraa-Oddi-LFMC and nlraa-AgronJ-paper) that used to be distributed with the package have been moved to the documentation above because of CRAN size limits.

[Nonlinear Models (video) - part I](https://www.youtube.com/watch?v=fIQV4JxXnnA)

[Nonlinear Models (video) - part II](https://www.youtube.com/watch?v=6ujBQxKYlwY)

[Nonlinear Models (video) - part III](https://www.youtube.com/watch?v=cDm9UhwGSXo)

To install

> library(remotes) \
> remotes::install_github("femiguez/nlraa") \
> library(nlraa)

This package supports the following publications:

1. Archontoulis, S. V., and F. E. Miguez. 2015. Nonlinear Regression
   Models and Applications in Agricultural
   Research. Agron. J. 107:786-798. \
   https://doi.org/10.2134/agronj2012.0506

2. Miguez, F., S. Archontoulis, H. Dokoohaki 2018. Chapter 15:
   Nonlinear Regression Models and Applications. In: B. Glaz,
   K. M. Yeater, editors, Applied Statistics in Agricultural,
   Biological, and Environmental Sciences, ASA, CSSA, and SSSA,
   Madison, WI. p. 401-448. \
   https://doi.org/10.2134/appliedstatistics.2016.0003

3. Oddi et. al. (2019). A nonlinear mixed-effects modelling approach
   for ecological data: Using temporal dynamics of vegetation moisture
   as an example. Ecology and Evolution. \
   https://doi.org/10.1002/ece3.5543

Some recent publications which cite this package:

14\. Positive associations of soil organic matter and crop yields across a regional network of working farms. Emily E. Oldfield,Mark A. Bradford,Abigail J. Augarten, Eric T. Cooley, Amber M. Radatz, Timothy Radatz, Matthew D. Ruark. Soil Science Society of America. 2021.  https://doi.org/10.1002/saj2.20349

13\. Improvement of the Mass-Rearing Protocols for the South American Fruit Fly for Application of the Sterile Insect Technique. Mastrangelo et al. Insects 2021, 12(7), 622; https://doi.org/10.3390/insects12070622

12\. High-yielding sugarcane in tropical Brazil – Integrating field experimentation and modelling approach for assessing variety performances. Henrique Boriolo Dias, Geoff Inman-Bamber, Paulo Cesar Sentelhas, Yvette Everingham, Rodrigo Bermejo, Diomedes Christodoulou. Field Crops Research. 2021. https://doi.org/10.1016/j.fcr.2021.108323.

11\. Evaluation of mehlich-3 for determination of cation exchange capacity in Kansas soils. Edmond Bryan Rutter, Dorivar Ruiz Diaz,Lynn M. Hargrave. 2021. Soil Science Society of America. https://doi.org/10.1002/saj2.20354

10\. Effects of human disturbance on postnatal growth and baseline corticosterone in a long-lived bird. Hannah Watson, Pat Monaghan, Britt J Heidinger, Mark Bolton. Conservation Physiology, Volume 9, Issue 1, 2021. https://doi.org/10.1093/conphys/coab052

9\. The use of R in photosynthesis research. Yasi Liu, Xiangping Wang, Dayong Fan and Jiangshan Lai. Functional Plant Biology 1-8 https://doi.org/10.1071/FP21102

8\. Topographic effects on soil microclimate and surface cover crop residue decomposition in rolling cropland. Sam J. Leuthold, Dan Quinn, Fernando Miguez, Ole Wendroth, Monsterrat Salmerón, Hanna Poffenbarger. Agriculture, Ecosystems & Environment, Volume 320, 2021. https://doi.org/10.1016/j.agee.2021.107609.

7\. Long-term no-till increases soil nitrogen mineralization but does not affect 
optimal corn nitrogen fertilization practices relative to inversion tillage. 
Lucas Pecci Canisares, John Grove, Fernando Miguez and Hanna Poffenbarger. 
Soil and Tillage Research. Volume 213. 2021. 105080. https://doi.org/10.1016/j.still.2021.105080.

6\. Rotating maize reduces the risk and rate of nitrate leaching. 
Heather Randolph Pasley, Nichols Virginia, Michael J Castellano, Matthew J Helmers, 
Mitchell E Baum, Eileen J Kladivko and Sotirios Archontoulis. 2021. Environmental
Research Letters. https://doi.org/10.1088/1748-9326/abef8f

5\. Abendroth, L.J., Miguez, F.E., Castellano, M.J., Carter, P.R., Messina, 
C.D., Dixon, P.M. and Hatfield, J.L. (2021), Lengthening of maize maturity 
time is not a widespread climate change adaptation strategy in the US Midwest. 
Glob Change Biol. https://doi.org/10.1111/gcb.15565

4\. Interactive effect of glyphosate-based herbicides and organic soil layer 
thickness on growth and reproduction of the tropical earthworm 
Pontoscolex corethrurus (Müller, 1857). Garcia-Perez et al. (2020).
https://doi.org/10.1016/j.apsoil.2020.103648

3\. Cuando la variabilidad varía: Heterocedasticidad y funciones de varianza. 
Oddi, F. J., Miguez, F. E., Benedetti, G. G., & Garibaldi, L. A. (2020). 
Ecología Austral; 30; 438-453.

2\. Short-term effects of integrated tillage systems and cover crop on
agronomic response and soil health in North Central Iowa. Alex Cleveringa. 2020.
MS Thesis. Iowa State University.

1\. The Effects of Agronomic Management and 40 Years of Variety Release on 
Soybean Seed Fill and Yield Components. Kathryn Graf. 2018. MS thesis. 
Purdue University.

Other publications where we have used nonlinear mixed models:

1. Fernando E. Miguez, María Bonita Villamil, Stephen P. Long,
    Germán A. Bollero, Meta-analysis of the effects of management
    factors on Miscanthus × giganteus growth and biomass production,
    Agricultural and Forest Meteorology, Volume 148, Issues 8–9, 2008,
    Pages 1280-1292, ISSN 0168-1923, \
    https://doi.org/10.1016/j.agrformet.2008.03.010. \
	Supporting information: \
	http://miguezlab.agron.iastate.edu/OldWebsite/Research/Miscanthus/MetaMiscan.tar.gz

2. Eichenberger, S., F. Miguez, J. Edwards, and A. Knapp. 2015. Changes
    in Kernel Filling with Selection for Grain Yield in a Maize
    Population. Crop Sci. 55:521-526. \
	https://doi.org/10.2135/cropsci2014.07.0462

3. Stein, M., F. Miguez, and J. Edwards. 2016. Effects of Plant Density
    on Plant Growth before and after Recurrent Selection in
    Maize. Crop Sci. 56:2882-2894. \
	https://doi.org/10.2135/cropsci2015.09.0599

Talks:

2008 ACS meeting.

Slides: \
http://miguezlab.agron.iastate.edu/OldWebsite/Research/Talks/ASA_Miguez.pdf

Data and code: \
http://miguezlab.agron.iastate.edu/OldWebsite/Research/Talks/Barley.zip




