% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy.nlslist.R
\name{tidy.nlsList}
\alias{tidy.nlsList}
\title{Tidy method for nlsList}
\usage{
\method{tidy}{nlsList}(x, conf.int = FALSE, conf.level = 0.95,
  quick = FALSE, ...)
}
\arguments{
\item{x}{An object returned by \code{\link{nlsList}}}

\item{conf.int}{Whether to calculate confidence intervals}

\item{conf.level}{The level of the confidence interval}

\item{quick}{If TRUE, only returns the coefficients.}

\item{\dots}{Further arguments passed to \code{\link{tidy}}}
}
\description{
Adds a method to \code{\link{tidy}} (broom package), so that we can use it for models fitted with \code{\link{nlsList}}.
}
\examples{
chick <- as.data.frame(ChickWeight)

# Fit an nlsList model, with a grouping variable (Diet)
fit1 <- nlsList(weight ~ a*Time^b | Diet, data=chick, start=list(a=10, b=1.1))

# Collect coefficients
tidy(fit1)

# ... and confidence intervals
tidy(fit1, conf.int=TRUE)
}

