## ---- include = FALSE----------------------------------------------------
library(nlstimedist)
knitr::opts_chunk$set(collapse = TRUE,
                      comment = "#>")

## ------------------------------------------------------------------------
head(tilia)

## ------------------------------------------------------------------------
tdTilia <- tdData(tilia, x = "Day", y = "Trees")
tdTilia

## ------------------------------------------------------------------------
model <- timedist(data = tdTilia, x = "Day", y = "propMax", r = 0.1, c = 0.5, t = 120)
model

## ------------------------------------------------------------------------
model$m$getMoments()

## ------------------------------------------------------------------------
model$m$rss()

## ------------------------------------------------------------------------
tdPdfPlot(model)

## ------------------------------------------------------------------------
tdCdfPlot(model)

