% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moments.R
\name{tdMoments}
\alias{tdEntropy}
\alias{tdKurtosis}
\alias{tdMean}
\alias{tdMoments}
\alias{tdSkew}
\alias{tdVariance}
\title{Calculate moments for the fitted timedist model}
\usage{
tdMoments(r, c, t, ...)

tdMean(r, c, t, upper = t * 10, ...)

tdVariance(r, c, t, upper = t * 10, ...)

tdSkew(r, c, t, upper = t * 10, ...)

tdKurtosis(r, c, t, upper = t * 10, alternative = FALSE, ...)

tdEntropy(r, c, t, upper = t * 10, ...)
}
\arguments{
\item{r, c, t}{Parameters of the Franco distribution}

\item{...}{Additional arguments to be passed to
\code{\link[stats]{integrate}}}

\item{upper}{The upper limit of integration. Defaults to \code{t * 10}. Can
be infinite for all moment functions except for entropy.}

\item{alternative}{An alternative calculation method.}
}
\value{
A single value, or in the case of \code{tdMoments}, a
  \code{data.frame} of values.
}
\description{
Individual functions are provided as well as a wrapper to
calculate the moments for your fitted model.
}
\examples{
tdMoments(r = 0.1, c = 0.5, t = 120)

tdMean(r = 0.1, c = 0.5, t = 120)
tdVariance(r = 0.1, c = 0.5, t = 120)
tdSkew(r = 0.1, c = 0.5, t = 120)
tdKurtosis(r = 0.1, c = 0.5, t = 120)
tdKurtosis(r = 0.1, c = 0.5, t = 120, alternative = TRUE)
tdEntropy(r = 0.1, c = 0.5, t = 120)
}

