context("Test the pdf and cdf functions: tdPDF and tdCDF")

test_that("Ensure the pdf and cdf functions return the expected values", {

  # 9 and 29 are the minimum values of the Day variable in the lobelia data
  testPdf <- tdPDF(x = seq(from = 9, to = 29, by = 29 / 100),
                   r = 0.01, c = 0.05, t = 150)
  expectPdf <- c(
    1.25622410729896e-05, 1.28728409620067e-05, 1.31898221657915e-05,
    1.3513304405406e-05, 1.3843409523116e-05, 1.41802615180222e-05,
    1.45239865824145e-05, 1.4874713139187e-05, 1.52325718791031e-05,
    1.55976957994708e-05, 1.5970220242793e-05, 1.63502829364018e-05,
    1.67380240325266e-05, 1.71335861488079e-05, 1.75371144103716e-05,
    1.79487564913659e-05, 1.83686626579653e-05, 1.87969858117422e-05,
    1.92338815339677e-05, 1.96795081301859e-05, 2.01340266759586e-05,
    2.05976010630109e-05, 2.10703980465657e-05, 2.15525872924327e-05,
    2.20443414261906e-05, 2.25458360821435e-05, 2.3057249953392e-05,
    2.35787648423613e-05, 2.41105657130191e-05, 2.46528407427938e-05,
    2.52057813762014e-05, 2.57695823785267e-05, 2.63444418911212e-05,
    2.69305614867759e-05, 2.75281462267327e-05, 2.8137404718012e-05,
    2.87585491719564e-05, 2.93917954632235e-05, 3.00373631904589e-05,
    3.06954757369973e-05, 3.13663603333758e-05, 3.20502481200082e-05,
    3.27473742114729e-05, 3.34579777612047e-05, 3.41823020279343e-05,
    3.49205944421114e-05, 3.56731066744306e-05, 3.64400947042529e-05,
    3.72218188903758e-05, 3.80185440417223e-05, 3.88305394895149e-05,
    3.9658079161056e-05, 4.05014416532427e-05, 4.13609103091541e-05,
    4.22367732936212e-05, 4.31293236717825e-05, 4.40388594876447e-05,
    4.4965683844435e-05, 4.59101049854267e-05, 4.68724363769127e-05,
    4.78529967915685e-05, 4.88521103936548e-05, 4.98701068249673e-05,
    5.09073212923196e-05, 5.19640946563528e-05, 5.30407735213497e-05,
    5.41377103267337e-05, 5.52552634392658e-05, 5.63937972477277e-05
  )
  expect_equal(testPdf, expectPdf)

  testCdf <- tdCDF(x = seq(from = 0, to = 1, by = 1 / 100),
                   r = 0.01, c = 0.05, t = 150)
  expectCdf <- c(
    0, 5.53056456187306e-08, 1.10666577235463e-07, 1.66082836261516e-07,
    2.21554463997187e-07, 2.7708150218686e-07, 3.32663992130833e-07,
    3.88301975351446e-07, 4.43995493482063e-07, 4.99744588156048e-07,
    5.55549300895741e-07, 6.11409673445529e-07, 6.67325747327752e-07,
    7.23297564397818e-07, 7.79325166289091e-07, 8.35408594745957e-07,
    8.91547891623823e-07, 9.47743098667075e-07, 1.00399425773112e-06,
    1.06030141067137e-06, 1.11666459945425e-06, 1.17308386582415e-06,
    1.22955925196955e-06, 1.28609079963482e-06, 1.34267855100845e-06,
    1.39932254805686e-06, 1.45602283285751e-06, 1.51277944737682e-06,
    1.5695924339143e-06, 1.6264618345474e-06, 1.68338769135357e-06,
    1.7403700466323e-06, 1.79740894257208e-06, 1.85450442147239e-06,
    1.91165652552172e-06, 1.96886529713058e-06, 2.0261307787095e-06,
    2.08345301244695e-06, 2.14083204075344e-06, 2.19826790615052e-06,
    2.25576065115973e-06, 2.31331031808057e-06, 2.37091694943459e-06,
    2.42858058796536e-06, 2.48630127597238e-06, 2.54407905631027e-06,
    2.60191397138954e-06, 2.65980606395377e-06, 2.71775537674657e-06,
    2.77576195228946e-06, 2.83382583343705e-06, 2.89194706304396e-06,
    2.95012568374275e-06, 3.00836173838803e-06, 3.06665526983441e-06,
    3.12500632104751e-06, 3.18341493477092e-06, 3.24188115419233e-06,
    3.30040502205531e-06, 3.3589865813255e-06, 3.41762587519057e-06,
    3.47632294661615e-06, 3.5350778386789e-06, 3.59389059445547e-06,
    3.65276125713354e-06, 3.71168986990078e-06, 3.77067647583385e-06,
    3.82972111823143e-06, 3.88882384039224e-06, 3.94798468550395e-06,
    4.00720369686525e-06, 4.06648091799688e-06, 4.12581639197551e-06,
    4.18521016232187e-06, 4.24466227255671e-06, 4.30417276597872e-06,
    4.36374168621967e-06, 4.42336907668928e-06, 4.48305498079726e-06,
    4.54279944239744e-06, 4.60260250489952e-06, 4.66246421193528e-06,
    4.72238460713648e-06, 4.7823637342459e-06, 4.84240163711736e-06,
    4.90249835916057e-06, 4.96265394434037e-06, 5.02286843651056e-06,
    5.08314187930292e-06, 5.1434743167933e-06, 5.20386579261345e-06,
    5.26431635095026e-06, 5.32482603554651e-06, 5.38539489047807e-06,
    5.44602295970975e-06, 5.50671028731742e-06, 5.5674569172659e-06,
    5.62826289363105e-06, 5.68912826059975e-06, 5.75005306235887e-06,
    5.81103734298427e-06
  )
  expect_equal(testCdf, expectCdf)
})


