% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/000functions.R
\name{get_npar}
\alias{get_npar}
\title{\code{get_npar} Get number of parameters or vector of parameters in supplied equations.
Extracts the number of parameters used in equations. Parameters are given as par[1], ..., par[n].}
\usage{
get_npar(x, values = FALSE)
}
\arguments{
\item{x}{List of strings.}

\item{values}{if \code{TRUE} returns the character vector with parameters (par[i]).}
}
\value{
Number of parameters or vector with parameters (in form par[i]).
}
\description{
\code{get_npar} Get number of parameters or vector of parameters in supplied equations.
Extracts the number of parameters used in equations. Parameters are given as par[1], ..., par[n].
}
\examples{
eq_d <- c("ASC1 * 1 + B11_dur * dur_1" , "ASC2 * 1 + B12_dur * dur_2",
"ASC3 * 1 + B13_dur * dur_3 + B20_cost * cost_3 + B53_parkman * PbAvl_3",
"ASC4 * 1 + B14_dur * dur_4 + B20_cost * cost_4 + B34_serv * servIdx_4 + B44_stop * stopUs1R1_4")
parl <- c("ASC1", "B11_dur", "ASC2", "B12_dur", "ASC3", "B13_dur", "B20_cost", "B53_parkman",
"ASC4", "B14_dur", "B20_cost", "B34_serv", "B44_stop") \%>\% unique
disc_par <- get_par(parl, eq_d)
get_npar(disc_par$cheqs0)
get_npar(disc_par$cheqs0, values=TRUE)

}
