% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/004functions.R, R/007functions.R
\name{nmm}
\alias{nmm}
\alias{summary.nmm}
\alias{nmm_sigma}
\title{Maximum likelihood estimation of nonlinear multivariate models (NMM).}
\usage{
nmm(
  data,
  eq_type = c("joint", "cont", "disc"),
  eq_d = NULL,
  eq_c = NULL,
  par_c = NULL,
  par_d = NULL,
  start_v = NULL,
  check_hess = TRUE,
  corrl = TRUE,
  weight_paths = TRUE,
  weight_paths_cont = FALSE,
  data_weight = NULL,
  estimate = TRUE,
  fixed_term = FALSE,
  best_method = FALSE,
  DEoptim_run = FALSE,
  hessian = "joint_hess",
  print_out = FALSE,
  diff_hessian = FALSE,
  bayesian_random = FALSE,
  DEoptim_run_main = FALSE,
  deconst = 2,
  numerical_deriv = FALSE,
  best_method4start = FALSE,
  eqsys = "sur",
  miterlim = 10000,
  opt_method = "BFGS",
  try_last_DEoptim = TRUE,
  transform = NULL,
  MNtypef = "logit",
  nmm_object = NULL
)

\method{summary}{nmm}(object, type = "normal", new_coef = NULL, ...)

nmm_sigma(
  object,
  methodopt = "BFGS",
  try_1good = TRUE,
  try_DEoptim = FALSE,
  try_diff_method = FALSE,
  trace = FALSE,
  estimate = FALSE
)
}
\arguments{
\item{data}{\code{data.frame} used in the optimization.}

\item{eq_type}{Possible options "joint", "cont", "disc".}

\item{eq_d}{Discrete equations.}

\item{eq_c}{Continuous equations.}

\item{par_c}{Parameters from continuous equations.}

\item{par_d}{Parameters from discrete equations.}

\item{start_v}{Starting values for optimization. 
If \code{NULL}, starting values are found by \code{get_start}  function.}

\item{check_hess}{If \code{TRUE}, check the Hessian.}

\item{corrl}{If \code{TRUE},  correlation between blocks (continuous and discrete).}

\item{weight_paths}{If \code{TRUE}, weight according to the number of choices made by individual i will be added to 
the whole system.}

\item{weight_paths_cont}{If \code{TRUE}, if only to continuous part should be weighted.}

\item{data_weight}{Data weight matrix.}

\item{estimate}{If \code{TRUE}, estimation is performed.}

\item{fixed_term}{If \code{TRUE}, includes fixed term to continuous equation block.}

\item{best_method}{If \code{TRUE}, all optimizers are checked.}

\item{DEoptim_run}{If \code{TRUE}, runs \code{DEoptim} in generation of starting values.}

\item{hessian}{String, name of the Hessian function.}

\item{print_out}{If \code{TRUE}, prints out log-likelihood for each equation.}

\item{diff_hessian}{If \code{TRUE}, for changing hessian and gradient with weights.}

\item{bayesian_random}{If \code{TRUE}, than par[1] is changed to par[,1] to be used for 
optimization of random parameters in Bayesian estimation.}

\item{DEoptim_run_main}{If \code{TRUE}, run \code{DEoptim} in the main optimization.}

\item{deconst}{absolute value of lower and upper bound in \code{DEoptim} optimization.}

\item{numerical_deriv}{If \code{TRUE}, uses numerical derivative instead of the analytical.}

\item{best_method4start}{If \code{TRUE}, all optimizers are checked for starting values.}

\item{eqsys}{"sur" or "sem".}

\item{miterlim}{Number many iterations passed to \code{maxLik} function}

\item{opt_method}{optimization method for \code{maxLik}.}

\item{try_last_DEoptim}{If \code{TRUE}, in case of error in \code{maxLik} should \code{DEoptim} be run.}

\item{transform}{if \code{TRUE}, quantile transformation is applied to discrete equations.}

\item{MNtypef}{estimate "logit", or "dogit"}

\item{nmm_object}{\code{nmm} object created by \code{nmm} function.}

\item{object}{\code{nmm} object, for \code{summary} and \code{nmm_sigma}}

\item{type}{Type of standard errors c("robust", "clustered", "normal"), for \code{summary}}

\item{new_coef}{New coefficients that will be tested, for \code{summary}}

\item{...}{additional arguments affecting the summary produced, for \code{summary}}

\item{methodopt}{optimizer from \code{maxLik} package, for \code{nmm_sigma}}

\item{try_1good}{If \code{TRUE}, stops then first good values are found, for \code{nmm_sigma}}

\item{try_DEoptim}{If \code{TRUE}, uses \code{DEoptim} for optimization, 
then \code{maxLik} optimizers produce errors, for \code{nmm_sigma}}

\item{try_diff_method}{If \code{TRUE}, stops then first good values with Hessian check are found, for \code{nmm_sigma}}

\item{trace}{If \code{TRUE}, trace of \code{DEoptim} is printed, for \code{nmm_sigma}}
}
\value{
\item{\code{nmm}}{returns \code{nmm} object with estimated parameters, functions, and data.}
\item{\code{nmm_sigma}}{returns estimated parameters, functions, data.}
\item{\code{summary}}{returns summary of \code{nmm} object.}
}
\description{
\code{nmm}, \code{nmm_sigma} and \code{summary} are the main functions used for the estimation of NMM.
\itemize{
\item{\code{nmm}}{ - Maximum likelihood estimation of nonlinear multivariate models (NMM)}
\item{\code{nmm_sigma}}{ - Optimizes the covariance matrix}
\item{\code{summary}}{ - returns summary of \code{nmm} object with "normal", "robust" or "clustered" standard errors. With option \code{new_coef} one can supply new coefficients and test their significance.}
}
}
\examples{
# estimation of System of Nonlinear Equations based on example from 'systemfit'
library(systemfit)
data( ppine , package="systemfit")
hg.formula <- hg ~ exp( h0 + h1*log(tht) + h2*tht^2 + h3*elev)
dg.formula <- dg ~ exp( d0 + d1*log(dbh) + d2*hg + d3*cr)
labels <- list( "height.growth", "diameter.growth" )
model <- list( hg.formula, dg.formula )
start.values <- c(h0=-0.5, h1=0.5, h2=-0.001, h3=0.0001,
                  d0=-0.5, d1=0.009, d2=0.25, d3=0.005)
model.sur <- nlsystemfit( "SUR", model, start.values, data=ppine, eqnlabels=labels )
eq_c <- as.character(c(hg.formula, dg.formula))
parl <- c(paste0("h", 0:3),paste0("d", 0:3))
res <- nmm(ppine, eq_c=eq_c, par_c=parl, start_v = start.values,
eq_type = "cont", best_method = FALSE, numerical_deriv=TRUE)
summary(res)
res_sigma_cont <- nmm_sigma(res,estimate=TRUE) # Estimation of the Variance-Covariance matrix
summary(res_sigma_cont)

#example discrete choice
library(mlogit)
data("Fishing", package = "mlogit")
Fish <- mlogit.data(Fishing, varying = c(2:9), shape = "wide", choice = "mode")
## a pure "conditional" model
mres <- summary(mlogit(mode ~ price + catch, data = Fish))
data <- prepare_data(Fish \%>\% data.frame \%>\% dplyr::select(-idx),
choice="alt", dummy="mode", PeID="chid", mode_spec_var = c("price", "catch"),
 type="long")
eq_d <- c("a1 + p1 * price_1 + p2 * catch_2", "a2 + p1 * price_2 + p2 * catch_2",
             "a3 + p1 * price_3 + p2 * catch_3", "a4 + p1 * price_4 + p2 * catch_4")
par_d <- c(paste0("a", 1:4), paste0("p", 1:2))
res <- nmm(data, eq_d=eq_d, par_d = par_d,  eq_type="disc", fixed_term=FALSE,
best_method=FALSE)
summary(res)

# joint estimation mockup example
data(dataM)
dataMp <- dataM \%>\% data.frame \%>\% prepare_data(. , choice="DR_Course", 
PeID = "Student")
eq_c <- c("PlcmtScore ~ exp(a0 + a1 * PSATM + a2 * Rank + a3 * Size)",
"ACTM ~ exp(c0 + c1 * GPAadj)")
par_c <- c(paste0("a", 0:3), paste0("c", 0:1))
eq_d <- c("ASC1" ,
"ASC2 + b1_2 * SATM + b2_2 * PlcmtScore",
"ASC3 + b1_3 * SATM + b2_3 * PlcmtScore")
par_d <- c(paste0("ASC", 1:3), paste0("b", rep(1:2, rep(2,2)), "_", 2:3))
\donttest{
nmm_joint_res <- nmm(dataMp, eq_type = "joint", eq_d = eq_d, 
par_d = par_d,  eq_c = eq_c, par_c = par_c, 
start_v = c(a0=3.394, a1=0.001, a2=-0.001, a3=0, c0=3.583, c1=-0.008, 
ASC2=-1.452, ASC3=3.047, b1_2=0.145, b1_3=0.102, b2_2=-0.133, b2_3=-0.168))
summary(nmm_joint_res)
}
}
