% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{luz_model_sequential}
\alias{luz_model_sequential}
\title{Build a \code{luz} model composed of a linear stack of layers}
\usage{
luz_model_sequential(...)
}
\arguments{
\item{...}{Sequence of modules to be added.}
}
\value{
A \code{nn_sequential} module.
}
\description{
Helper function to build \code{luz} models as a sequential model, by feeding
it a stack of \code{luz} layers.
}
\details{
This step is needed so we can get the activation functions and
layers and neurons architecture easily with \code{nn2poly:::get_parameters()}.
Furthermore, this step is also needed to be able to impose the needed
constraints when using the \code{luz/torch} framework.
}
\examples{
\dontrun{
if (requireNamespace("luz", quietly=TRUE)) {
# Create a NN using luz/torch as a sequential model
# with 3 fully connected linear layers,
# the first one with input = 5 variables,
# 100 neurons and tanh activation function, the second
# one with 50 neurons and softplus activation function
# and the last one with 1 linear output.
nn <- luz_model_sequential(
  torch::nn_linear(5,100),
  torch::nn_tanh(),
  torch::nn_linear(100,50),
  torch::nn_softplus(),
  torch::nn_linear(50,1)
)

nn

# Check that the nn is of class nn_squential
class(nn)
}
}

}
\seealso{
\code{\link[=add_constraints]{add_constraints()}}
}
