% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logistf.fit.R
\name{logistf.fit}
\alias{logistf.fit}
\title{Fit a Firth logistic regression model}
\usage{
logistf.fit(
  x,
  y,
  weight = NULL,
  offset = NULL,
  firth = TRUE,
  col.fit = NULL,
  init = NULL,
  control
)
}
\arguments{
\item{x}{A model matrix returned by \code{\link[stats]{model.matrix}}}

\item{y}{The response of a model frame returned by \code{\link[stats]{model.response}}}

\item{weight}{An optional weighting variable for each observation}

\item{offset}{An optional offset variable}

\item{firth}{Use of Firth's penalized maximum likelihood (firth=TRUE, default)
or the standard maximum likelihood method (firth=FALSE)}

\item{col.fit}{Numerical vector containing the positions of the variables to
fit, if not specified: all variables are taken}

\item{init}{Specifies the initial values of the coefficients for the fitting algorithm}

\item{control}{Controls Newton-Raphson iteration. Default is
\code{control= logistf.control(maxstep, maxit, maxhs, lconv, gconv, xconv)}}
}
\description{
Fit a Firth logistic regression model
}
