% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.r
\name{tct}
\alias{tct}
\title{\eqn{T} Contingency Table (TCT)}
\usage{
tct(ct, type = "III")
}
\arguments{
\item{ct}{A nearest neighbor contingency table}

\item{type}{The type of the cell-specific test, default=\code{"III"}. Takes on values \code{"I"}-\code{"IV"} (or 
equivalently \code{1-4}, respectively.}
}
\value{
A \code{matrix} of the values of Type I-IV cell-specific tests
}
\description{
Returns the \code{T} contingency table (TCT), which is a matrix of same dimension as, \code{ct}, 
whose entries are the values of the Types I-IV cell-specific test statistics, \eqn{T^I_{ij}-T^{IV}_{ij}}. 
The row and column names are inherited from \code{ct}. The type argument specifies the type
of the cell-specific test among the types I-IV tests. 

See also (\insertCite{ceyhan:jkss-posthoc-2017;textual}{nnspat}) and the references therein.
}
\examples{
n<-20  #or try sample(1:20,1)
Y<-matrix(runif(3*n),ncol=3)
ipd<-ipd.mat(Y)
cls<-sample(1:2,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))
ct<-nnct(ipd,cls)
ct

type.lab<-c("I","II","III","IV")
for (i in 1:4)
{ print(paste("T_ij values for cell specific tests for type",type.lab[i]))
  print(tct(ct,i))
}

tct(ct,"II")

#cls as a factor
na<-floor(n/2); nb<-n-na
fcls<-rep(c("a","b"),c(na,nb))
ct<-nnct(ipd,fcls)
tct(ct,2)

#############
n<-40
Y<-matrix(runif(3*n),ncol=3)
ipd<-ipd.mat(Y)
cls<-sample(1:4,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))
ct<-nnct(ipd,cls)
tct(ct,2)

ct<-matrix(c(0,10,5,5),ncol=2)
tct(ct,2)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{cellsTij}} and \code{\link{nnct}}
}
\author{
Elvan Ceyhan
}
