% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjust.R
\name{match_forecast_county}
\alias{match_forecast_county}
\title{Match events by forecast zone to county}
\usage{
match_forecast_county(storm_data_z)
}
\arguments{
\item{storm_data_z}{A dataframe of storm events reported by forecast zone
(i.e., \code{cz_type == "Z"}) rather than county. This dataframe should
include the columns:
\itemize{
  \item{\code{state}: }{State name, in lowercase}
  \item{\code{cz_name}: }{Location name, in lowercase}
  \item{\code{cz_fips}: }{Forecast zone FIPS}
}}
}
\value{
The dataframe of events input to the function, with county FIPS
   added for events matched to a county in the \code{fips} column. Events
   that could not be matched are kept in the dataframe, but the \code{fips}
   code is set to \code{NA}.
}
\description{
For events reported by forecast zone, use regular expressions to match
as many as possible to counties.
}
\details{
This function tries to match the \code{cz_name} of each event to
   a state and county name from the \code{county.fips} dataframe that comes
   with the \code{maps} package. The following steps are taken to try to
   match each \code{cz_name} to a state and county name from \code{county.fips}:
   \enumerate{
     \item Tries to match \code{cz_name} to the county name in \code{county.fips}
       after removing any periods or apostrophes in \code{cz_name}.
     \item Next, for county names with "county" in them, try to match the word before
        "county" to county name in \code{county.fips}. Then check the two words before
        "county", then the one and two words before "counties".
     \item Next, pull out the last word in \code{cz_name} and try to match it to the county
        name in \code{county.fips}. The check the last two words in \code{cz_name}, then check
        the last three words in \code{cz_name}.
     \item Next, pull any words right before a slash and check that against the county name.
     \item Finally, try removing anything in parentheses in \code{cz_name} before matching.
   }
}
\note{
This function does not provide any matches for events outside
   of the continental U.S.

You may want to hand-check that event listings with names like "Lake", "Mountain", and
   "Park" have not been unintentionally linked to a county like "Lake County". While such
   examples seem rare in the example data used to develop this function (NOAA Storm Events
   for 2015), it can sometimes happen. To do so, you can use the \code{str_detect} function
   from the \code{stringr} package.
}
\examples{
counties_to_parse <- dplyr::data_frame(
           event_id = c(1:19),
           cz_name = c("Suffolk",
                       "Eastern Greenbrier",
                       "Ventura County Mountains",
                       "Central And Southeast Montgomery",
                       "Western Cape May",
                       "San Diego County Coastal Areas",
                       "Blount/Smoky Mountains",
                       "St. Mary's",
                       "Central & Eastern Lake County",
                       "Mountains Southwest Shasta County To Northern Lake County",
                       "Kings (Brooklyn)",
                       "Lower Bucks",
                       "Central St. Louis",
                       "Curry County Coast",
                       "Lincoln County Except The Sheep Range",
                       "Shasta Lake/North Shasta County",
                       "Coastal Palm Beach County",
                       "Larimer & Boulder Counties Between 6000 & 9000 Feet",
                       "Yellowstone National Park"),
          state = c("Virginia",
                    "West Virginia",
                    "California",
                    "Maryland",
                    "New Jersey",
                    "California",
                    "Tennessee",
                    "Maryland",
                    "Oregon",
                    "California",
                    "New York",
                    "Pennsylvania",
                    "Minnesota",
                    "Oregon",
                    "Nevada",
                    "California",
                    "Florida",
                    "Colorado",
                    "Wyoming"))
match_forecast_county(counties_to_parse)
}
