% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smoothing-rules.R
\name{smooth_lin}
\alias{smooth_lin}
\title{Linear first-order smoothing rule}
\usage{
smooth_lin(x, xt, a)
}
\arguments{
\item{x}{\code{numeric} value of the last value of the parameter.}

\item{xt}{\code{numeric} vector of past values of the parameter (time series).}

\item{a}{smoothing parameter \eqn{a}.}
}
\value{
A \code{numeric} vector of updated parameters.
}
\description{
Linear smoothing rule
\deqn{x_{t+1}:=a\,x_t + (1-a)\,x_{t-1}}
for some \eqn{a\in[0,1]}.
}
\seealso{
Other smoothing rules: \code{\link{smooth_dec}}
}
\concept{smoothing rules}
