% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lin1.R
\name{lin1}
\alias{lin1}
\title{Lin 1 (LIN1) Measure}
\usage{
lin1(data)
}
\arguments{
\item{data}{A \emph{data.frame} or a \emph{matrix} with cases in rows and variables in colums.}
}
\value{
The function returns an object of class "dist".
\cr
}
\description{
A function for calculation of a proximity (dissimilarity) matrix based on the LIN1 similarity measure.
}
\details{
The Lin 1 similarity measure was introduced in (Boriah et al., 2008) as a modification of the original Lin measure (Lin, 1998). In has
a complex system of weights. In case of mismatch, lower similarity is assigned if either
the mismatching values are very frequent or their relative frequency is in between the relative
frequencies of mismatching values. Higher similarity is assigned if the mismatched categories
are infrequent and there are a few other infrequent categories. In case of match,
lower similarity is given for matches on frequent categories or matches on categories
that have many other values of the same frequency. Higher similarity is given to matches
on infrequent categories.
}
\examples{
# sample data
data(data20)

# dissimilarity matrix calculation
prox.lin1 <- lin1(data20)

}
\references{
Boriah S., Chandola V., Kumar V. (2008). Similarity measures for categorical data: A comparative evaluation.
In: Proceedings of the 8th SIAM International Conference on Data Mining, SIAM, p. 243-254.
 \cr
 \cr
Lin D. (1998). An information-theoretic definition of similarity.
In: ICML '98: Proceedings of the 15th International Conference on Machine Learning. San Francisco, p. 296-304.
}
\seealso{
\code{\link[nomclust]{eskin}},
\code{\link[nomclust]{good1}},
\code{\link[nomclust]{good2}},
\code{\link[nomclust]{good3}},
\code{\link[nomclust]{good4}},
\code{\link[nomclust]{iof}},
\code{\link[nomclust]{lin}},
\code{\link[nomclust]{of}},
\code{\link[nomclust]{sm}},
\code{\link[nomclust]{ve}},
\code{\link[nomclust]{vm}}.
}
\author{
Zdenek Sulc. \cr Contact: \email{zdenek.sulc@vse.cz}
}
