% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/of.R
\name{of}
\alias{of}
\title{Occurence Frequency (OF) Measure}
\usage{
of(data, var.weights = NULL)
}
\arguments{
\item{data}{A data.frame or a matrix with cases in rows and variables in columns.}

\item{var.weights}{A numeric vector setting weights to the used variables. One can choose the real numbers from zero to one.}
}
\value{
The function returns an object of the class "dist".
\cr
}
\description{
The function calculates a dissimilarity matrix based on the OF similarity measure.
}
\details{
The OF (Occurrence Frequency) measure was originally constructed for the text mining tasks,
see (Sparck-Jones, 1972), later, it was adjusted for categorical variables, see (Boriah et al., 2008)
It assigns higher weight to mismatches on less frequent values and otherwise.
}
\examples{
# sample data
data(data20)

# dissimilarity matrix calculation
prox.of <- of(data20)

# dissimilarity matrix calculation with variable weights
weights.of <- of(data20, var.weights = c(0.7, 1, 0.9, 0.5, 0))

}
\references{
Boriah S., Chandola V., Kumar V. (2008). Similarity measures for categorical data: A comparative evaluation.
In: Proceedings of the 8th SIAM International Conference on Data Mining, SIAM, p. 243-254.
 \cr
 \cr
Spark-Jones K. (1972). A statistical interpretation of term specificity and its application in retrieval.
In Journal of Documentation, 28(1), p. 11-21. Later: Journal of Documentation, 60(5) (2002), p. 493-502.
}
\seealso{
\code{\link[nomclust]{anderberg}},
\code{\link[nomclust]{burnaby}},
\code{\link[nomclust]{eskin}},
\code{\link[nomclust]{gambaryan}},
\code{\link[nomclust]{goodall1}},
\code{\link[nomclust]{goodall2}},
\code{\link[nomclust]{goodall3}},
\code{\link[nomclust]{goodall4}},
\code{\link[nomclust]{iof}},
\code{\link[nomclust]{lin}},
\code{\link[nomclust]{lin1}},
\code{\link[nomclust]{sm}},
\code{\link[nomclust]{smirnov}},
\code{\link[nomclust]{ve}},
\code{\link[nomclust]{vm}}.
}
\author{
Zdenek Sulc. \cr Contact: \email{zdenek.sulc@vse.cz}
}
