% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateData.r
\name{genSimData}
\alias{genSimData}
\title{Simulation data}
\usage{
genSimData(N = 10000, n = 1000)
}
\arguments{
\item{N}{\code{integer}, population size, default 10000}

\item{n}{\code{integer}, big data sample, default 1000}
}
\value{
\code{genSimData} returns a data.frame, with the following columns:
\itemize{
\item{x0 -- intercept}
\item{x1 -- the first variable based on z1}
\item{x2 -- the second variable based on z2 and x1}
\item{x3 -- the third variable based on z3 and x1 and x2}
\item{x4 -- the third variable based on z4 and x1, x2 and x3}
\item{\mjseqn{y30} -- \mjseqn{y} generated from the model \mjseqn{y=2+x1+x2+x3+x4+\sigma \cdot \varepsilon}, so the cor(y,y_hat) = 0.30}
\item{\mjseqn{y60} -- \mjseqn{y} generated from the model \mjseqn{y=2+x1+x2+x3+x4+\sigma \cdot \varepsilon}, so the cor(y,y_hat) = 0.60}
\item{\mjseqn{y80} -- \mjseqn{y} generated from the model \mjseqn{y=2+x1+x2+x3+x4+\sigma \cdot \varepsilon}, so the cor(y,y_hat) = 0.80}
\item{rho -- true propensity scores for big data such that sum(rho)=n}
\item{srs -- probabilities of inclusion to random sample such that max(srs)/min(srs)=50}
}
}
\description{
Generate simulated data according to Chen, Li & Wu (2020), section 5.

\loadmathjax
}
\examples{
## generate data with N=20000 and n=2000
genSimData(N = 20000, n = 2000)

## generate data when big data is almost as N
genSimData(N = 10000, n = 9000)

}
\references{
Chen, Y., Li, P., & Wu, C. (2020). Doubly Robust Inference With Nonprobability Survey Samples. Journal of the American Statistical Association, 115(532), 2011–2021. doi:10.1080/01621459.2019.1677241
}
\author{
Łukasz Chrostowski, Maciej Beręsewicz
}
