% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qtr2month.r
\name{qtr2month}
\alias{qtr2month}
\title{Quarterly to monthly transformation}
\usage{
qtr2month(x, reference_month = 3, interpolation = FALSE)
}
\arguments{
\item{x}{a \code{ts} or \code{mts} in quarterly frequency}

\item{reference_month}{a integer to define the position of a quarter value in a quarter. Default is 3. The options are 1, 2 or 3.}

\item{interpolation}{logical. The NA values can be estimated by linear interpolation (approx function from stats package). Default is FALSE.}
}
\value{
The correpondent monthly transformation.
}
\description{
It transforms a quarterly  time series in a monthly one. The values of the quarterly \code{ts} are set to the last month of the quarter.
}
\examples{
# Selecting the quarterly GDP variable in BRGDP
qtr2month(BRGDP$GDP) 

}
