% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_pd.R
\name{computepd}
\alias{computepd}
\title{Internal functions used to compute prediction discrepancies}
\usage{
computepd(npdeObject,...)
}
\arguments{
\item{npdeObject}{an object of class NpdeObject}

\item{\ldots}{additional options to modify}
}
\value{
an object of class NpdeObject; the results slot will now include prediction discrepancies (pd) as well as model predictions (ypred) obtained as the mean of the simulated data for each observation
}
\description{
Functions used by \code{npde} and \code{autonpde} to compute prediction
discrepancies (not intended for the end-user).
}
\details{
These functions are normally not called by the end-user.
}
\references{
K. Brendel, E. Comets, C. Laffont, C. Laveille, and F.
Mentre. Metrics for external model evaluation with an application to the
population pharmacokinetics of gliclazide. \emph{Pharmaceutical Research},
23:2036--49, 2006.
}
\seealso{
\code{\link{npde}}, \code{\link{autonpde}}
}
\author{
Emmanuelle Comets <emmanuelle.comets@bichat.inserm.fr>
}
\keyword{internal}
