% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/npc.R
\name{npc}
\alias{npc}
\title{Calculate the Neyman-Pearson Classifier from a sample of class 0 and class 1.}
\usage{
npc(x = NULL, y, method = c("logistic", "penlog", "svm", "randomforest",
  "lda", "nb", "ada", "custom"), score = NULL, pred.score = NULL,
  alpha = 0.05, delta = 0.05, split = TRUE, loc.prob = NULL,
  n.cores = 1)
}
\arguments{
\item{x}{n * p observation matrix. n observations, p covariates.}

\item{y}{n 0/1 observatons.}

\item{method}{classification method.
\itemize{
\item logistic: \link{glm} function with family = 'binomial'
\item penlog: \code{\link[glmnet]{glmnet}} in \code{glmnet} package
\item svm: \code{\link[e1071]{svm}} in \code{e1071} package
\item randomforest: \code{\link[randomForest]{randomForest}} in \code{randomForest} package
\item lda: \code{\link[MASS]{lda}} in \code{MASS} package
\item nb: \code{\link[e1071]{naiveBayes}} in \code{e1071} package
\item ada: \code{\link[ada]{ada}} in \code{ada} package
\item custom: a custom classifier. score vector needed.
}}

\item{score}{score vector corresponding to y. Required when method  = 'custom'.}

\item{pred.score}{predicted score vector for the test sample. Optional when method  = 'custom'.}

\item{alpha}{the desirable control on type I error. Default = 0.05.}

\item{delta}{the violation rate of the type I error. Default = 0.05.}

\item{split}{whether the class 0 sample is split into two parts. Default =
TRUE. When method = 'custom', split = FALSE always.}

\item{loc.prob}{the precalculated threshold locations in probability.
Default = NULL.}

\item{n.cores}{number of cores used for parallel computing. Default = 1.}
}
\value{
An object with S3 class npc.
\item{fit}{fit the fit from the specified classifier.}
\item{score}{the score vector for each observation.}
 \item{cutoff}{thecutoff determined via bootstrap to achieve the specified type I error
  control.}
 \item{sign}{whether class 1 has a larger average score than the
  class 0.}
 \item{method}{the method of the classifier.}
 \item{loc.prob}{the
  percentile used to determine the cutoff for the specified type I error
  control.}
}
\description{
\code{npc} calculate the Neyman-Pearson Classifier for a given type I error
constraint.
}
\examples{
n = 1000
x = matrix(rnorm(n*2),n,2)
c = 1+3*x[,1]
y = rbinom(n,1,1/(1+exp(-c)))
xtest = matrix(rnorm(n*2),n,2)
ctest = 1+3*xtest[,1]
ytest = rbinom(n,1,1/(1+exp(-ctest)))

##Use svm classifier and the default type I error control with alpha=0.05
fit = npc(x, y, method = 'svm')
pred = predict(fit,xtest)
fit.score = predict(fit,x)
accuracy = mean(pred$pred.label==ytest)
cat('Overall Accuracy: ',  accuracy,'\\n')
ind0 = which(ytest==0)
typeI = mean(pred$pred.label[ind0]!=ytest[ind0]) #type I error on test set
cat('Type I error: ', typeI, '\\n')

##Now, change the method to logistic regression and change alpha to 0.1
fit = npc(x, y, method = 'logistic', alpha = 0.1)
pred = predict(fit,xtest)
accuracy = mean(pred$pred.label==ytest)
cat('Overall Accuracy: ',  accuracy,'\\n')
ind0 = which(ytest==0)
typeI = mean(pred$pred.label[ind0]!=ytest[ind0]) #type I error on test set
cat('Type I error: ', typeI, '\\n')

##Now, change the method to adaboost
#fit = npc(x, y, method = 'ada', alpha = 0.1)
#pred = predict(fit,xtest)
#accuracy = mean(pred$pred.label==ytest)
#cat('Overall Accuracy: ',  accuracy,'\\n')
#ind0 = which(ytest==0)
#typeI = mean(pred$pred.label[ind0]!=ytest[ind0]) #type I error on test set
#cat('Type I error: ', typeI, '\\n')

##A 'custom' npc classifier with y and score.
#fit2 = npc(y = y, score = fit.score$pred.score,
#pred.score = pred$pred.score, method = 'custom')
}
\seealso{
\code{\link{nproc}} and \code{\link{predict.npc}}
}

