% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_calls_authentification.R
\name{get_disruptions_station}
\alias{get_disruptions_station}
\alias{get_current_disruptions}
\alias{get_scheduled_engineering_work}
\title{Get disruptions and engineering work}
\usage{
get_disruptions_station(station)

get_current_disruptions()

get_scheduled_engineering_work()
}
\arguments{
\item{station}{optional, station names need to be in Dutch and the NS webservice also accepts short versions:f.i. Groningen or GN}
}
\value{
a dataframe
}
\description{
These 3 functions call out to find out about disruptions and engineering on
the tracks for the current time, for the next 2 weeks or a specific station.
}
\details{
\itemize{
\item current disruptions  (=unscheduled disruptions + current engineering work)
}

These are all the disruptions of the railroad at this moment. So both
unscheduled work and work
and work that was scheduled and currently underway.
Use \code{get_current_disruptions()}
\itemize{
\item scheduled engineering work(=scheduled engineering work)
}

Get all the scheduled engineering work for the next 2 weeks
with \code{get_scheduled_engineering_work()}. This will exclude
work that was unplanned.
\itemize{
\item current disruptions for a specific station (=unscheduled disruptions + current engineering work)
}

Use \code{get_disruptions_station()} and give a station name as argument.

\url{https://www.ns.nl/en/travel-information/ns-api/documentation-disruptions-and-maintenance-work.html}
}
\section{Functions}{
\itemize{
\item \code{get_current_disruptions}: current disruptions

\item \code{get_scheduled_engineering_work}: scheduled disruptions
}}

