% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nzilbb.labbcat.R
\name{labbcat.getAvailableMedia}
\alias{labbcat.getAvailableMedia}
\title{List the media available for the given graph.}
\usage{
labbcat.getAvailableMedia(labbcat, id)
}
\arguments{
\item{labbcat}{A LaBB-CAT instance object previously created by a call to labbcat.instance}

\item{id}{A graph ID (i.e. transcript name)}
}
\value{
A named list of media files available for the given graph, with members:
\enumerate{
 \item{trackSuffix The track suffix of the media}
 \item{mimeType The MIME type of the file}
 \item{url URL to the content of the file}
 \item{name Name of the file}
}
}
\description{
List the media available for the given graph.
}
\examples{
## Connect to LaBB-CAT
labbcat <- labbcat.instance("https://labbcat.canterbury.ac.nz/demo/", "demo", "demo")

## List the media files available for BR2044_OllyOhlson.eaf
media <- labbcat.getAvailableMedia(labbcat, "BR2044_OllyOhlson.eaf")

}
\seealso{
\link{labbcat.getGraphIds}
}
\keyword{audio}
\keyword{media}
