% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nzilbb.labbcat.R
\name{labbcat.getGraphIdsWithParticipant}
\alias{labbcat.getGraphIdsWithParticipant}
\title{Gets a list of IDs of graphs that include the given participant.}
\usage{
labbcat.getGraphIdsWithParticipant(labbcat, id)
}
\arguments{
\item{labbcat}{A LaBB-CAT instance object previously created by a call to labbcat.instance}

\item{id}{A participant ID}
}
\value{
A list of graph IDs
}
\description{
Returns a list of IDs of graphs (i.e. transcript names) that include
the given participant.
}
\examples{
## Connect to LaBB-CAT
labbcat <- labbcat.instance("https://labbcat.canterbury.ac.nz/demo/", "demo", "demo")

## List transcripts in which UC427_ViktoriaPapp_A_ENG speaks
transcripts <- labbcat.getGraphIdsWithParticipant(labbcat, "UC427_ViktoriaPapp_A_ENG")

}
\seealso{
\code{\link{labbcat.getParticipantIds}}
}
\keyword{graph}
\keyword{transcript}
