% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/praatScriptFastTrack.R
\name{praatScriptFastTrack}
\alias{praatScriptFastTrack}
\title{Generates a script for extracting formants using FastTrack, for use with \link{processWithPraat}.}
\usage{
praatScriptFastTrack(
  formants = c(1, 2),
  sample.points = c(0.5),
  lowest.analysis.frequency = 5000,
  lowest.analysis.frequency.male = 4500,
  highest.analysis.frequency = 7000,
  highest.analysis.frequency.male = 6500,
  gender.attribute = "participant_gender",
  value.for.male = "M",
  time.step = 0.002,
  tracking.method = "burg",
  number.of.formants = 3,
  maximum.f1.frequency = 1200,
  maximum.f1.bandwidth = NULL,
  maximum.f2.bandwidth = NULL,
  maximum.f3.bandwidth = NULL,
  minimum.f4.frequency = 2900,
  enable.rhotic.heuristic = TRUE,
  enable.f3.f4.proximity.heuristic = TRUE,
  number.of.steps = 20,
  number.of.coefficients = 5
)
}
\arguments{
\item{formants}{A vector of integers specifying which formants to extract, e.g c(1,2)
for the first and second formant.}

\item{sample.points}{A vector of numbers (0 <= sample.points <= 1) specifying multiple
points at which to take the measurement.  The default is a single point at 0.5 -
this means one measurement will be taken halfway through the target interval.  If,
for example, you wanted eleven measurements evenly spaced throughout the interval,
you would specify sample.points as being
c(0.0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0).}

\item{lowest.analysis.frequency}{Lowest analysis frequency (Hz) by default.}

\item{lowest.analysis.frequency.male}{Lowest analysis frequency (Hz) for male
speakers, or NULL to use the same value as lowest.analysis.frequency.}

\item{highest.analysis.frequency}{Highest analysis frequency (Hz) by default.}

\item{highest.analysis.frequency.male}{Highest analysis frequency (Hz) for male
speakers, or NULL to use the same value as highest.analysis.frequency.}

\item{gender.attribute}{Name of the LaBB-CAT participant attribute that contains the
participant's gender - normally this is "participant_gender".}

\item{value.for.male}{The value that the gender.attribute has when the participant is male.}

\item{time.step}{Time step in seconds.}

\item{tracking.method}{tracking_method parameter for trackAutoselectProcedure; "burg"
or "robust".}

\item{number.of.formants}{Number of formants to track - 3 or 4.}

\item{maximum.f1.frequency}{Specifying a non-NULL value enables the F1 frequency
heuristic: Median F1 frequency should not be higher than this value.}

\item{maximum.f1.bandwidth}{Specifying a non-NULL value (e.g. 500)
enables the F1 bandwidth heuristic: Median F1 bandwidth should not be higher than
this value.}

\item{maximum.f2.bandwidth}{Specifying a non-NULL value (e.g. 600)
enables the F2 bandwidth heuristic: Median F2 bandwidth should not be higher than
this value.}

\item{maximum.f3.bandwidth}{Specifying a non-NULL value (e.g. 900)
enables the F3 bandwidth heuristic: Median F3 bandwidth should not be higher than
this value.}

\item{minimum.f4.frequency}{Specifying a non-NULL value enables the F4 frequency
heuristic: Median F4 frequency should not be lower than this value.}

\item{enable.rhotic.heuristic}{Whether to enable the rhotic heuristic: If F3 < 2000 Hz,
F1 and F2 should be at least 500 Hz apart.}

\item{enable.f3.f4.proximity.heuristic}{Whether to enable the F3/F4 proximity
heuristic: If (F4 - F3) < 500 Hz, F1 and F2 should be at least 1500 Hz apart.}

\item{number.of.steps}{Number of analyses between low and high analysis limits. More
analysis steps may improve results, but will increase analysis time (50 percent more steps
= around 50 percent longer to analyze).}

\item{number.of.coefficients}{Number of coefficients for formant prediction. More
coefficients allow for more sudden, and 'wiggly' formant motion.}
}
\value{
A script fragment which can be passed as the praat.script parameter of
    \link{processWithPraat}
}
\description{
This function generates a Praat script fragment which can be passed as the praat.script
parameter of \link{processWithPraat}, in order to extract selected formants using the
FastTrack Praat plugin.
}
\details{
The FastTrack Praat plugin, developed by Santiago Barreda, automatically runs multiple
formant analyses on each segment, selects the best (the smoothest, with optional
heuristics), and makes the winning formant object available for measurement. For more
information, see \url{https://github.com/santiagobarreda/FastTrack}
}
\examples{
\dontrun{
## define the LaBB-CAT URL
labbcat.url <- "https://labbcat.canterbury.ac.nz/demo/"

## Get all tokens of the KIT vowel
results <- getMatches(labbcat.url, list(segment="I"))

## Get the first 3 formants at three points during the vowel
formants <- processWithPraat(
              labbcat.url,
              results$MatchId, results$Target.segment.start, results$Target.segment.end,
              window.offset=0.025,
              praatScriptFastTrack(formants=c(1,2,3),
              sample.points=c(0.25,0.5,0.75)))
}
}
\seealso{
\link{processWithPraat}

\link{praatScriptCentreOfGravity}

\link{praatScriptIntensity}

\link{praatScriptPitch}

\link{praatScriptFormants}
}
\keyword{praat}
