% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/renameParticipants.R
\name{renameParticipants}
\alias{renameParticipants}
\title{Renames a list of participants.}
\usage{
renameParticipants(labbcat.url, current.ids, new.ids, no.progress = FALSE)
}
\arguments{
\item{labbcat.url}{URL to the LaBB-CAT instance}

\item{current.ids}{A vector of participant IDs that as they are currently defined in
the corpus.}

\item{new.ids}{A vector of new participant IDs, each element corresponding to an ID in
current.ids.}

\item{no.progress}{TRUE to supress visual progress bar. Otherwise, progress bar will be
shown when interactive().}
}
\value{
A vector of results, each element corresponding to an ID in current.ids. If the
  ID was successfully changed, the corresponding element is TRUE. If the ID could not
  be changed (e.g. because there is already an existing participant using the new ID),
  then the corresponding element is FALSE.
}
\description{
This function changes the IDs of a given set of participants, where possible.
}
\examples{
\dontrun{
## define the LaBB-CAT URL
labbcat.url <- "https://labbcat.canterbury.ac.nz/demo/"

## Create some new participant records
old.ids <- c("test-id-1","test-id-2","test-id-3")
for (id in old.ids) saveParticipant(labbcat.url, id)

## Batch change the IDs
new.ids <- c("test-id-1-changed","test-id-2-changed","test-id-3-changed")
renameParticipants(labbcat.url, old.ids, new.ids)

## Delete the participants we just created
for (id in new.ids) deleteParticipant(labbcat.url, id)
}

}
\seealso{
\code{\link{getParticipantIds}}
  \code{\link{getMatchingParticipantIds}}
  \code{\link{getParticipant}}
  \code{\link{saveParticipant}}
  \code{\link{deleteParticipant}}
}
\keyword{participant}
