% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/df.R
\name{df_order_by_col}
\alias{df_order_by_col}
\title{Sort data.frame by column name}
\usage{
df_order_by_col(df, col, decreasing = FALSE, on_missing_col = "warn")
}
\arguments{
\item{df}{data.frame, input data.frame}

\item{col}{string, column name as sort source}

\item{decreasing}{flag, should the sort order be increasing or decreasing?}

\item{on_missing_col}{string, behavior for missing column(s):
"warn" - log warning, "skip" - skip missing column(s), "stop" - throw error}
}
\value{
Modified input data.frame
}
\description{
Sort data.frame by column name
}
\examples{
df <- data.frame(
  a = c("a", "b", "c"),
  b = c(1, 3, 2),
  c = c(3, 2, 1)
)
df_order_by_col(df, "b", decreasing = TRUE)
df_order_by_col(df, "c")

}
