% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{occSimpFilter}
\alias{occSimpFilter}
\title{Runs tests and validates data}
\usage{
occSimpFilter(
  spOcc,
  env,
  speciesName = "My species",
  x = "x",
  y = "y",
  date = NULL,
  isoCountry = NULL,
  classification = "majority",
  filterCols = TRUE
)
}
\arguments{
\item{spOcc}{data.frame. Object with the coordinate data.}

\item{env}{raster or rasterStack. Environmental data (e.g. typically climatic).}

\item{speciesName}{character. Name of the species.}

\item{x}{name of the field with the coordinate x. Default 'x'}

\item{y}{name of the field with the coordinate y. Default 'y'}

\item{date}{name of the field with the values of the reported timestamp of the record. Default NULL}

\item{isoCountry}{name of the field with the values of the reported country of the record. Default NULL}

\item{classification}{character. Indicates the thresholds philosophy applied to classify errors in occurrence data. Possible values 'strict','relaxed','custom'}

\item{filterCols}{logical. Should only the initial input columns be retained in the output (the filtered dataframe)?}
}
\value{
a list of two. First element is a data.frame with profiled occurrence records with their associated profiled labels. Second element is a dataframe with all outputs of the analysis implemented.
}
\description{
Runs tests and validates data
}
\note{
The majority of function parameters can be adjusted but we  provide default values. \cr 
We recommend those default values if the user is to use the geospatial data included in the package.\cr
but this automatic implementation (occTest + occFilter) missses some analysis to increase speed.
}
\examples{
\donttest{
### THIS IS A CUT DOWN  EXAMPLE 
### visit vignetteXtra-occTest for more info
#load environmental raster
library (raster)
library (sf)
library (occTest)
#load occurrence data
occData <- read.csv (system.file('ext/exampleOccData.csv',package = 'occTest'))
#load environmental raster
renv <- raster (system.file('ext/AllEnv.tif',package = 'occTest'))
#load elevation raster
dem <- raster (system.file('ext/DEM.tif',package = 'occTest'))
#load settings
settings <- readRDS (system.file('ext/exSettings.rds',package = 'occTest'))
#run occTest
out = occTest(sp.name='MyFake species',
             sp.table = occData,ntv.ctry = 'ESP',inv.ctry = 'FRA',
             tableSettings = settings$tableSettings,
             writeoutSettings = settings$writeoutSettings,
             analysisSettings = settings$analysisSettings,
             r.env = renv,r.dem=dem)
#filter
occFilter(out)
}
}
\author{
Josep M Serra-Diaz (pep.serradiaz@agroparistech.fr)
}
