% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nativeStatusCtry.R
\name{nativeStatusCtry}
\alias{nativeStatusCtry}
\title{Check native and alien ranges in countries}
\usage{
nativeStatusCtry(
  spName,
  xydat,
  resolveNative = TRUE,
  resolveAlien = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{spName}{character. Species name in the form of Genus species}

\item{xydat}{dataframe Species longitude latitude coordinates.}

\item{resolveNative}{logical. Should the function attempt to find countries where species are considered native?}

\item{resolveAlien}{logical. Should the function attempt to find countries where species are considered introduced?}

\item{verbose}{logical. Want to print information during the process?}
}
\value{
list with two vectors: ntvCtry and invCtry, showing the countries in ISO3 standard codes
}
\description{
performs several queries based on the orignir package to identify native and invasive range status for a given species
}
\details{
right now based on the package originr, which queries on Flora Europea, GISD or Native species resolver. Future implementation may query more databases.
}
\examples{
\donttest{
#needs spocc library
df <- spocc::occ(query = 'Pseudotsuga menziesii')
occ.data <- spocc::occ2df(df)
nativeStatusCtry(spName = 'Pseudotsuga menziesii',xydat = occ.data[,2:3])
}
}
\seealso{
Other spStatus: 
\code{\link{ctryToIso3}()}
}
\author{
Josep M Serra-Diaz (pep.serradiaz@agroparistech.fr)
}
\concept{spStatus}
\keyword{internal}
