% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/page.R
\name{set_item_data}
\alias{set_item_data}
\title{Set / save data for an item.}
\usage{
set_item_data(
  session,
  page_id,
  item_id = NULL,
  question_text = NULL,
  response_text = NULL,
  response_id = NULL
)
}
\arguments{
\item{session}{The shiny session}

\item{page_id}{The page for which to retrieve data.}

\item{item_id}{The item for which to set/update data.
This \emph{has} to be different for different items on the same page.
Since most pages contain only a single question/item, \code{item_id} is set to "default" if missing.}

\item{question_text}{The question's text. (optional)}

\item{response_text}{The user's response in text form. (optional)}

\item{response_id}{The user's response as an id from a set of choices.
(optional)}
}
\value{
nothing
}
\description{
There can be multiple items on any given page. Items can be different
questions, or multiple variables that need to be saved from a single
question. The \code{question_text} is typically
saved in \code{run_before} and the reply (\code{response_text} and/or \code{response_id}) is
typically saved in \code{run_after}.
}
\examples{
# Set up a "fake" shiny session to store data
session <- shiny::MockShinySession$new()
session$userData <- list(
  current_page_id = "other_page",
  questionnaire_data = list(
    example_page = list()
  )
)

# This code is expected to be run in e.g. run_before or run_after
# It doesn't really make sense to run this code outside
set_item_data(
  session = session,
  page_id = "example_page",
  question_text = "How are you?"
)

set_item_data(
  session = session,
  page_id = "example_page",
  response_id = 3,
  response_text = "I'm doing great! (response_id = 3)"
)
}
\seealso{
\code{\link[=get_item_data]{get_item_data()}}
}
