% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameter-labeller.R
\name{env_parm_labeller}
\alias{env_parm_labeller}
\title{Parsing expressions for plot labels}
\usage{
env_parm_labeller(var, prefix = character(1), postfix = character(1))
}
\arguments{
\item{var}{Environmental parameter.}

\item{prefix}{Prefix.}

\item{postfix}{Postfix.}
}
\value{
Expression
}
\description{
Conveniently converts NOAA world ocean atlas parameter names into full
oceanographic variable names including units for parsing in plot labels.
}
\examples{

# expression
env_parm_labeller("t_an")

# plot with temperature axis label
library(ggplot2)

ggplot() +
 geom_blank() +
 ylab(env_parm_labeller("t_an"))


}
