% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/identical_structure.R
\name{identical_structure}
\alias{identical_structure}
\title{Check if two objects have identical structure}
\usage{
identical_structure(x, y)
}
\arguments{
\item{x, y}{[\code{any}]\cr
Two objects.}
}
\value{
Either \code{TRUE} if \code{x} and \code{y} have the same structure, and
\code{FALSE}, else.
}
\description{
This function determines whether two objects have the same structure,
\itemize{
\item which includes the \code{\link[base]{mode}}, \code{\link[base]{class}} and
dimension
\item but does \emph{not} include concrete values or attributes.
}
}
\examples{
identical_structure(integer(1), 1L)
identical_structure(diag(2), matrix(rnorm(4), 2, 2))
identical_structure(diag(2), data.frame(diag(2)))
}
\references{
Inspired by \url{https://stackoverflow.com/a/45548885/15157768}.
}
\seealso{
Other package helpers: 
\code{\link{Dictionary}},
\code{\link{Storage}},
\code{\link{check_missing}()},
\code{\link{input_check_response}()},
\code{\link{match_arg}()},
\code{\link{package_logo}()},
\code{\link{print_data.frame}()},
\code{\link{print_matrix}()},
\code{\link{system_information}()},
\code{\link{unexpected_error}()},
\code{\link{user_confirm}()}
}
\concept{package helpers}
\keyword{validation}
