% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ols-regression.R
\name{ols_regress}
\alias{ols_regress}
\alias{ols_regress.lm}
\title{Ordinary Least Squares Regression}
\usage{
ols_regress(object, ...)

\method{ols_regress}{lm}(object, ...)
}
\arguments{
\item{object}{an object of class "formula" (or one that can be coerced to
that class): a symbolic description of the model to be fitted.}

\item{...}{other inputs}
}
\value{
\code{ols_regress} returns an object of class \code{"ols_regress"}. An object
of class \code{"ols_regress"} is a list containing the following
components:

\item{r}{f statistic}
\item{rsq}{pure error}
\item{adjr}{regression sum of squares}
\item{sigma}{error sum of squares}
\item{cv}{total sum of squares}
\item{mse}{mean squared error}
\item{mae}{p-value of \code{fstat}}
\item{aic}{degrees of freedom}
\item{sbc}{name(s) of \code{variable}}
\item{sbic}{name of \code{group_var}}
\item{prsq}{f statistic}
\item{error_df}{p-value of \code{fstat}}
\item{model_df}{degrees of freedom}
\item{total_df}{name(s) of \code{variable}}
\item{ess}{name of \code{group_var}}
\item{rss}{f statistic}
\item{tss}{p-value of \code{fstat}}
\item{rms}{degrees of freedom}
\item{ems}{name(s) of \code{variable}}
\item{f}{name of \code{group_var}}
\item{p}{name of \code{group_var}}
\item{n}{p-value of \code{fstat}}
\item{betas}{degrees of freedom}
\item{sbetas}{name(s) of \code{variable}}
\item{std_errors}{name of \code{group_var}}
\item{tvalues}{f statistic}
\item{pvalues}{p-value of \code{fstat}}
\item{df}{degrees of freedom}
\item{conf_lm}{name(s) of \code{variable}}
\item{title}{name of \code{group_var}}
\item{dependent}{f statistic}
\item{predictors}{p-value of \code{fstat}}
\item{mvars}{degrees of freedom}
\item{model}{name(s) of \code{variable}}
}
\description{
Ordinary Least Squares Regression
}
\examples{
ols_regress(mpg ~ disp + hp + wt, data = mtcars)
}

