% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ols-stepwise-forward-regression.R
\name{ols_step_forward}
\alias{ols_step_forward}
\alias{ols_step_forward.default}
\alias{plot.ols_step_forward}
\title{Stepwise Forward Regression}
\usage{
ols_step_forward(model, ...)

\method{ols_step_forward}{default}(model, penter = 0.3, details = FALSE,
  ...)

\method{plot}{ols_step_forward}(x, model = NA, ...)
}
\arguments{
\item{model}{an object of class \code{lm}; the model should include all candidate predictor variables}

\item{...}{other arguments}

\item{penter}{p value; variables with p value less than \code{penter} will enter into the model}

\item{details}{logical; if \code{TRUE}, will print the regression result at each step}

\item{x}{an object of class \code{ols_step_forward}}
}
\value{
\code{ols_step_forward} returns an object of class \code{"ols_step_forward"}.
An object of class \code{"ols_step_forward"} is a list containing the
following components:

\item{steps}{number of steps}
\item{predictors}{variables added to the model}
\item{rsquare}{coefficient of determination}
\item{aic}{akaike information criteria}
\item{sbc}{bayesian information criteria}
\item{sbic}{sawa's bayesian information criteria}
\item{adjr}{adjusted r-square}
\item{rmse}{root mean square error}
\item{mallows_cp}{mallow's Cp}
\item{indvar}{predictors}
}
\description{
Build regression model from a set of candidate predictor variables by entering predictors based on 
p values, in a stepwise manner until there is no variable left to enter any more.
}
\examples{
# stepwise forward regression
model <- lm(y ~ ., data = surgical)
ols_step_forward(model)

# stepwise forward regression plot
model <- lm(y ~ ., data = surgical)
k <- ols_step_forward(model)
plot(k)

}
\references{
Chatterjee, Samprit and Hadi, Ali. Regression Analysis by Example. 5th ed. N.p.: John Wiley & Sons, 2012. Print.

Kutner, MH, Nachtscheim CJ, Neter J and Li W., 2004, Applied Linear Statistical Models (5th edition). 
Chicago, IL., McGraw Hill/Irwin.
}
