% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mockCohort.R
\name{mockCohort}
\alias{mockCohort}
\title{Function to generate synthetic Cohort}
\usage{
mockCohort(
  cdm,
  name = "cohort",
  numberCohorts = 1,
  cohortName = paste0("cohort_", seq_len(numberCohorts)),
  recordPerson = 1,
  seed = 1
)
}
\arguments{
\item{cdm}{the CDM reference into which the synthetic cohort will be added}

\item{name}{The name of the table within the CDM where the cohort data will be stored. Defaults to "cohort".}

\item{numberCohorts}{The number of different cohorts to create within the table. Defaults to 1.}

\item{cohortName}{The name(s) of the cohorts to be created. This can be a single name or a vector of names if multiple cohorts are being created. Defaults to generating names based on a sequence.}

\item{recordPerson}{The expected number of records per person within each cohort. This can help simulate the frequency of observations for individuals in the cohort.}

\item{seed}{A random seed to ensure reproducibility of the generated data.}
}
\value{
A cdm reference with the mock tables
}
\description{
Function to generate synthetic Cohort
}
\examples{
library(omock)
cdm <- mockCdmReference() |>
  mockPerson(nPerson = 100) |>
  mockObservationPeriod() |>
  mockCohort(
    name = "omock_example",
    numberCohorts = 2,
    cohortName = c("omock_cohort_1", "omock_cohort_2")
  )

  cdm
}
